/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.classpath;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.classpath.BuildScriptClassPathCacheEntry;
import org.javacs.kt.classpath.BuildScriptClassPathCacheEntryEntity;
import org.javacs.kt.classpath.CachedClassPathResolver;
import org.javacs.kt.classpath.ClassPathCacheEntry;
import org.javacs.kt.classpath.ClassPathCacheEntryEntity;
import org.javacs.kt.classpath.ClassPathEntry;
import org.javacs.kt.classpath.ClassPathMetadataCache;
import org.javacs.kt.classpath.ClassPathMetadataCacheEntity;
import org.javacs.kt.classpath.ClassPathResolver;
import org.javacs.kt.classpath.ClasspathMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010'\u001a\u00020(H\u0002J\u0016\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001e\u0010,\u001a\u00020*2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010.\u001a\u00020(H\u0002R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR0\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00078B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\u000fR0\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00100\u00078B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\n\"\u0004\b\u0013\u0010\u000fR(\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u00158B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\nR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\nR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/javacs/kt/classpath/CachedClassPathResolver;", "Lorg/javacs/kt/classpath/ClassPathResolver;", "wrapped", "db", "Lorg/jetbrains/exposed/sql/Database;", "(Lorg/javacs/kt/classpath/ClassPathResolver;Lorg/jetbrains/exposed/sql/Database;)V", "buildScriptClasspath", "", "Ljava/nio/file/Path;", "getBuildScriptClasspath", "()Ljava/util/Set;", "newEntries", "cachedBuildScriptClassPathEntries", "getCachedBuildScriptClassPathEntries", "setCachedBuildScriptClassPathEntries", "(Ljava/util/Set;)V", "Lorg/javacs/kt/classpath/ClassPathEntry;", "cachedClassPathEntries", "getCachedClassPathEntries", "setCachedClassPathEntries", "newClassPathMetadata", "Lorg/javacs/kt/classpath/ClasspathMetadata;", "cachedClassPathMetadata", "getCachedClassPathMetadata", "()Lorg/javacs/kt/classpath/ClasspathMetadata;", "setCachedClassPathMetadata", "(Lorg/javacs/kt/classpath/ClasspathMetadata;)V", "classpath", "getClasspath", "classpathWithSources", "getClasspathWithSources", "currentBuildFileVersion", "", "getCurrentBuildFileVersion", "()J", "resolverType", "", "getResolverType", "()Ljava/lang/String;", "dependenciesChanged", "", "updateBuildScriptClasspathCache", "", "newClasspath", "updateClasspathCache", "newClasspathEntries", "includesSources", "shared"})
@SourceDebugExtension(value={"SMAP\nCachedClassPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachedClassPathResolver.kt\norg/javacs/kt/classpath/CachedClassPathResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1#2:178\n*E\n"})
public final class CachedClassPathResolver
implements ClassPathResolver {
    @NotNull
    private final ClassPathResolver wrapped;
    @NotNull
    private final Database db;

    public CachedClassPathResolver(@NotNull ClassPathResolver wrapped, @NotNull Database db) {
        Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.wrapped = wrapped;
        this.db = db;
        ThreadLocalTransactionManagerKt.transaction((Database)this.db, (Function1)1.INSTANCE);
    }

    @Override
    @NotNull
    public String getResolverType() {
        return "Cached + " + this.wrapped.getResolverType();
    }

    private final Set<ClassPathEntry> getCachedClassPathEntries() {
        return (Set)ThreadLocalTransactionManagerKt.transaction((Database)this.db, (Function1)cachedClassPathEntries.1.INSTANCE);
    }

    private final void setCachedClassPathEntries(Set<ClassPathEntry> newEntries) {
        ThreadLocalTransactionManagerKt.transaction((Database)this.db, (Function1)((Function1)new Function1<Transaction, Unit>(newEntries){
            final /* synthetic */ Set<ClassPathEntry> $newEntries;
            {
                this.$newEntries = $newEntries;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Transaction $this$transaction) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
                QueriesKt.deleteAll((Table)((Table)ClassPathCacheEntry.INSTANCE));
                Iterable $this$map$iv = this.$newEntries;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ClassPathEntry classPathEntry = (ClassPathEntry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((ClassPathCacheEntryEntity)ClassPathCacheEntryEntity.Companion.new((Function1)new Function1<ClassPathCacheEntryEntity, Unit>((ClassPathEntry)it){
                        final /* synthetic */ ClassPathEntry $it;
                        {
                            this.$it = $it;
                            super(1);
                        }

                        public final void invoke(@NotNull ClassPathCacheEntryEntity $this$new) {
                            Intrinsics.checkNotNullParameter((Object)((Object)$this$new), (String)"$this$new");
                            $this$new.setCompiledJar(((Object)this.$it.getCompiledJar()).toString());
                            Path path = this.$it.getSourceJar();
                            $this$new.setSourceJar(path != null ? ((Object)path).toString() : null);
                        }
                    }));
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
            }
        }));
    }

    private final Set<Path> getCachedBuildScriptClassPathEntries() {
        return (Set)ThreadLocalTransactionManagerKt.transaction((Database)this.db, (Function1)cachedBuildScriptClassPathEntries.1.INSTANCE);
    }

    private final void setCachedBuildScriptClassPathEntries(Set<? extends Path> newEntries) {
        ThreadLocalTransactionManagerKt.transaction((Database)this.db, (Function1)((Function1)new Function1<Transaction, Unit>(newEntries){
            final /* synthetic */ Set<Path> $newEntries;
            {
                this.$newEntries = $newEntries;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Transaction $this$transaction) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
                QueriesKt.deleteAll((Table)((Table)BuildScriptClassPathCacheEntry.INSTANCE));
                Iterable $this$map$iv = this.$newEntries;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((BuildScriptClassPathCacheEntryEntity)BuildScriptClassPathCacheEntryEntity.Companion.new((Function1)new Function1<BuildScriptClassPathCacheEntryEntity, Unit>((Path)it){
                        final /* synthetic */ Path $it;
                        {
                            this.$it = $it;
                            super(1);
                        }

                        public final void invoke(@NotNull BuildScriptClassPathCacheEntryEntity $this$new) {
                            Intrinsics.checkNotNullParameter((Object)((Object)$this$new), (String)"$this$new");
                            $this$new.setJar(((Object)this.$it).toString());
                        }
                    }));
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
            }
        }));
    }

    private final ClasspathMetadata getCachedClassPathMetadata() {
        return (ClasspathMetadata)ThreadLocalTransactionManagerKt.transaction((Database)this.db, (Function1)cachedClassPathMetadata.1.INSTANCE);
    }

    private final void setCachedClassPathMetadata(ClasspathMetadata newClassPathMetadata) {
        ThreadLocalTransactionManagerKt.transaction((Database)this.db, (Function1)((Function1)new Function1<Transaction, Unit>(newClassPathMetadata){
            final /* synthetic */ ClasspathMetadata $newClassPathMetadata;
            {
                this.$newClassPathMetadata = $newClassPathMetadata;
                super(1);
            }

            public final void invoke(@NotNull Transaction $this$transaction) {
                Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
                QueriesKt.deleteAll((Table)((Table)ClassPathMetadataCache.INSTANCE));
                ClasspathMetadata classpathMetadata = this.$newClassPathMetadata;
                if (classpathMetadata == null) {
                    classpathMetadata = new ClasspathMetadata(false, null, 3, null);
                }
                ClasspathMetadata newClassPathMetadataRow = classpathMetadata;
                ClassPathMetadataCacheEntity.Companion.new((Function1)new Function1<ClassPathMetadataCacheEntity, Unit>(newClassPathMetadataRow){
                    final /* synthetic */ ClasspathMetadata $newClassPathMetadataRow;
                    {
                        this.$newClassPathMetadataRow = $newClassPathMetadataRow;
                        super(1);
                    }

                    public final void invoke(@NotNull ClassPathMetadataCacheEntity $this$new) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$new), (String)"$this$new");
                        $this$new.setIncludesSources(this.$newClassPathMetadataRow.getIncludesSources());
                        $this$new.setBuildFileVersion(this.$newClassPathMetadataRow.getBuildFileVersion());
                    }
                });
            }
        }));
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspath() {
        Set<ClassPathEntry> it = this.getCachedClassPathEntries();
        boolean bl = false;
        if (!this.dependenciesChanged()) {
            LoggerKt.getLOG().info("Classpath has not changed. Fetching from cache", new Object[0]);
            return it;
        }
        LoggerKt.getLOG().info("Cached classpath is outdated or not found. Resolving again", new Object[0]);
        Set<ClassPathEntry> newClasspath = this.wrapped.getClasspath();
        this.updateClasspathCache(newClasspath, false);
        return newClasspath;
    }

    @Override
    @NotNull
    public Set<Path> getBuildScriptClasspath() {
        if (!this.dependenciesChanged()) {
            LoggerKt.getLOG().info("Build script classpath has not changed. Fetching from cache", new Object[0]);
            return this.getCachedBuildScriptClassPathEntries();
        }
        LoggerKt.getLOG().info("Cached build script classpath is outdated or not found. Resolving again", new Object[0]);
        Set<Path> newBuildScriptClasspath = this.wrapped.getBuildScriptClasspath();
        this.updateBuildScriptClasspathCache(newBuildScriptClasspath);
        return newBuildScriptClasspath;
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspathWithSources() {
        ClasspathMetadata classpathMetadata = this.getCachedClassPathMetadata();
        if (classpathMetadata != null) {
            ClasspathMetadata it = classpathMetadata;
            boolean bl = false;
            if (!this.dependenciesChanged() && it.getIncludesSources()) {
                return this.getCachedClassPathEntries();
            }
        }
        Set<ClassPathEntry> newClasspath = this.wrapped.getClasspathWithSources();
        this.updateClasspathCache(newClasspath, true);
        return newClasspath;
    }

    @Override
    public long getCurrentBuildFileVersion() {
        return this.wrapped.getCurrentBuildFileVersion();
    }

    private final void updateClasspathCache(Set<ClassPathEntry> newClasspathEntries, boolean includesSources) {
        ThreadLocalTransactionManagerKt.transaction((Database)this.db, (Function1)((Function1)new Function1<Transaction, Unit>(this, newClasspathEntries, includesSources){
            final /* synthetic */ CachedClassPathResolver this$0;
            final /* synthetic */ Set<ClassPathEntry> $newClasspathEntries;
            final /* synthetic */ boolean $includesSources;
            {
                this.this$0 = $receiver;
                this.$newClasspathEntries = $newClasspathEntries;
                this.$includesSources = $includesSources;
                super(1);
            }

            public final void invoke(@NotNull Transaction $this$transaction) {
                Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
                CachedClassPathResolver.access$setCachedClassPathEntries(this.this$0, this.$newClasspathEntries);
                ClasspathMetadata classpathMetadata = CachedClassPathResolver.access$getCachedClassPathMetadata(this.this$0);
                if (classpathMetadata == null || (classpathMetadata = classpathMetadata.copy(this.$includesSources, this.this$0.getCurrentBuildFileVersion())) == null) {
                    classpathMetadata = new ClasspathMetadata(false, null, 3, null);
                }
                CachedClassPathResolver.access$setCachedClassPathMetadata(this.this$0, classpathMetadata);
            }
        }));
    }

    private final void updateBuildScriptClasspathCache(Set<? extends Path> newClasspath) {
        ThreadLocalTransactionManagerKt.transaction((Database)this.db, (Function1)((Function1)new Function1<Transaction, Unit>(this, newClasspath){
            final /* synthetic */ CachedClassPathResolver this$0;
            final /* synthetic */ Set<Path> $newClasspath;
            {
                this.this$0 = $receiver;
                this.$newClasspath = $newClasspath;
                super(1);
            }

            public final void invoke(@NotNull Transaction $this$transaction) {
                Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
                CachedClassPathResolver.access$setCachedBuildScriptClassPathEntries(this.this$0, this.$newClasspath);
                ClasspathMetadata classpathMetadata = CachedClassPathResolver.access$getCachedClassPathMetadata(this.this$0);
                if (classpathMetadata == null || (classpathMetadata = ClasspathMetadata.copy$default(classpathMetadata, false, this.this$0.getCurrentBuildFileVersion(), 1, null)) == null) {
                    classpathMetadata = new ClasspathMetadata(false, null, 3, null);
                }
                CachedClassPathResolver.access$setCachedClassPathMetadata(this.this$0, classpathMetadata);
            }
        }));
    }

    private final boolean dependenciesChanged() {
        Object object = this.getCachedClassPathMetadata();
        return (object != null && (object = ((ClasspathMetadata)object).getBuildFileVersion()) != null ? (Long)object : 0L) < this.wrapped.getCurrentBuildFileVersion();
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspathOrEmpty() {
        return ClassPathResolver.DefaultImpls.getClasspathOrEmpty(this);
    }

    @Override
    @NotNull
    public Set<Path> getBuildScriptClasspathOrEmpty() {
        return ClassPathResolver.DefaultImpls.getBuildScriptClasspathOrEmpty(this);
    }

    public static final /* synthetic */ void access$setCachedClassPathEntries(CachedClassPathResolver $this, Set newEntries) {
        $this.setCachedClassPathEntries(newEntries);
    }

    public static final /* synthetic */ void access$setCachedClassPathMetadata(CachedClassPathResolver $this, ClasspathMetadata newClassPathMetadata) {
        $this.setCachedClassPathMetadata(newClassPathMetadata);
    }

    public static final /* synthetic */ ClasspathMetadata access$getCachedClassPathMetadata(CachedClassPathResolver $this) {
        return $this.getCachedClassPathMetadata();
    }

    public static final /* synthetic */ void access$setCachedBuildScriptClassPathEntries(CachedClassPathResolver $this, Set newEntries) {
        $this.setCachedBuildScriptClassPathEntries(newEntries);
    }
}

