/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.writers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import org.apache.hyracks.algebricks.data.IAWriter;
import org.apache.hyracks.algebricks.data.IAWriterFactory;
import org.apache.hyracks.algebricks.data.IPrinterFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class SerializedDataWriterFactory
implements IAWriterFactory {
    private static final long serialVersionUID = 1L;

    public IAWriter createWriter(final int[] fields, final PrintStream ps, IPrinterFactory[] printerFactories, final RecordDescriptor inputRecordDescriptor) {
        return new IAWriter(){

            public void init() throws HyracksDataException {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(inputRecordDescriptor);
                    baos.writeTo(ps);
                    oos.close();
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }

            public void printTuple(IFrameTupleAccessor tAccess, int tIdx) throws HyracksDataException {
                for (int i = 0; i < fields.length; ++i) {
                    int fldStart = tAccess.getTupleStartOffset(tIdx) + tAccess.getFieldSlotsLength() + tAccess.getFieldStartOffset(tIdx, fields[i]);
                    int fldLen = tAccess.getFieldLength(tIdx, fields[i]);
                    ps.write(tAccess.getBuffer().array(), fldStart, fldLen);
                }
            }
        };
    }
}

