/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.dataflow;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.dataflow.BTreeSearchOperatorNodePushable;
import org.apache.hyracks.storage.am.btree.impls.BatchPredicate;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTree;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeBatchPointSearchCursor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.projection.ITupleProjectorFactory;

public class LSMBTreeBatchPointSearchOperatorNodePushable
extends BTreeSearchOperatorNodePushable {
    private final int[] keyFields;

    public LSMBTreeBatchPointSearchOperatorNodePushable(IHyracksTaskContext ctx, int partition, RecordDescriptor inputRecDesc, int[] lowKeyFields, int[] highKeyFields, boolean lowKeyInclusive, boolean highKeyInclusive, int[] minFilterKeyFields, int[] maxFilterKeyFields, IIndexDataflowHelperFactory indexHelperFactory, boolean retainInput, boolean retainMissing, IMissingWriterFactory missingWriterFactory, ISearchOperationCallbackFactory searchCallbackFactory, ITupleFilterFactory tupleFilterFactory, long outputLimit, ITupleProjectorFactory tupleProjectorFactory) throws HyracksDataException {
        super(ctx, partition, inputRecDesc, lowKeyFields, highKeyFields, lowKeyInclusive, highKeyInclusive, minFilterKeyFields, maxFilterKeyFields, indexHelperFactory, retainInput, retainMissing, missingWriterFactory, searchCallbackFactory, false, null, tupleFilterFactory, outputLimit, false, null, null, tupleProjectorFactory);
        this.keyFields = lowKeyFields;
    }

    protected IIndexCursor createCursor() throws HyracksDataException {
        ILSMIndexAccessor lsmAccessor = (ILSMIndexAccessor)this.indexAccessor;
        return ((LSMBTree)this.index).createBatchPointSearchCursor(lsmAccessor.getOpContext());
    }

    protected ISearchPredicate createSearchPredicate() {
        ITreeIndex treeIndex = (ITreeIndex)this.index;
        this.lowKeySearchCmp = this.highKeySearchCmp = BTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])treeIndex.getComparatorFactories(), (ITupleReference)this.lowKey);
        return new BatchPredicate((IFrameTupleAccessor)this.accessor, this.lowKeySearchCmp, this.keyFields, this.minFilterFieldIndexes, this.maxFilterFieldIndexes);
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        if (this.accessor.getTupleCount() > 0) {
            BatchPredicate batchPred = (BatchPredicate)this.searchPred;
            batchPred.reset((IFrameTupleAccessor)this.accessor);
            try {
                this.indexAccessor.search(this.cursor, (ISearchPredicate)batchPred);
                this.writeSearchResults();
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            finally {
                this.cursor.close();
            }
        }
    }

    protected void writeSearchResults() throws IOException {
        long matchingTupleCount = 0L;
        LSMBTreeBatchPointSearchCursor batchCursor = (LSMBTreeBatchPointSearchCursor)this.cursor;
        int tupleIndex = 0;
        while (this.cursor.hasNext()) {
            this.cursor.next();
            ++matchingTupleCount;
            ITupleReference tuple = this.cursor.getTuple();
            if (this.tupleFilter != null) {
                this.referenceFilterTuple.reset(tuple);
                if (!this.tupleFilter.accept((IFrameTupleReference)this.referenceFilterTuple)) continue;
            }
            this.tb.reset();
            if (this.retainInput && this.retainMissing) {
                this.appendMissingTuple(tupleIndex, batchCursor.getKeyIndex());
            }
            tupleIndex = batchCursor.getKeyIndex();
            if (this.retainInput) {
                this.frameTuple.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
                for (int i = 0; i < this.frameTuple.getFieldCount(); ++i) {
                    this.dos.write(this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), this.frameTuple.getFieldLength(i));
                    this.tb.addFieldEndOffset();
                }
            }
            this.writeTupleToOutput(tuple);
            FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (int[])this.tb.getFieldEndOffsets(), (byte[])this.tb.getByteArray(), (int)0, (int)this.tb.getSize());
            if (this.outputLimit < 0L || ++this.outputCount < this.outputLimit) continue;
            this.finished = true;
            break;
        }
        this.stats.getInputTupleCounter().update(matchingTupleCount);
    }

    private void appendMissingTuple(int start, int end) throws HyracksDataException {
        for (int i = start; i < end; ++i) {
            FrameUtils.appendConcatToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (IFrameTupleAccessor)this.accessor, (int)i, (int[])this.nonMatchTupleBuild.getFieldEndOffsets(), (byte[])this.nonMatchTupleBuild.getByteArray(), (int)0, (int)this.nonMatchTupleBuild.getSize());
        }
    }
}

