/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jdbc.core;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.jdbc.core.ADBDatabaseMetaData;
import org.apache.asterix.jdbc.core.ADBDriverProperty;
import org.apache.asterix.jdbc.core.ADBErrorReporter;
import org.apache.asterix.jdbc.core.ADBMetaStatement;
import org.apache.asterix.jdbc.core.ADBPreparedStatement;
import org.apache.asterix.jdbc.core.ADBProductVersion;
import org.apache.asterix.jdbc.core.ADBProtocolBase;
import org.apache.asterix.jdbc.core.ADBStatement;
import org.apache.asterix.jdbc.core.ADBWrapperSupport;

public class ADBConnection
extends ADBWrapperSupport
implements Connection {
    protected final ADBProtocolBase protocol;
    protected final String url;
    protected final ADBProductVersion databaseVersion;
    protected final ADBDriverProperty.CatalogDataverseMode catalogDataverseMode;
    protected final boolean catalogIncludesSchemaless;
    protected final boolean sqlCompatMode;
    private final AtomicBoolean closed;
    private final ConcurrentLinkedQueue<ADBStatement> statements;
    private volatile SQLWarning warning;
    private volatile ADBMetaStatement metaStatement;
    private volatile String catalog;
    private volatile String schema;

    public ADBConnection(ADBProtocolBase protocol, String url, ADBProductVersion databaseVersion, String dataverseCanonicalName, Map<ADBDriverProperty, Object> properties, SQLWarning connectWarning) throws SQLException {
        this.url = Objects.requireNonNull(url);
        this.protocol = Objects.requireNonNull(protocol);
        this.databaseVersion = databaseVersion;
        this.statements = new ConcurrentLinkedQueue();
        this.warning = connectWarning;
        this.closed = new AtomicBoolean(false);
        this.sqlCompatMode = (Boolean)ADBDriverProperty.Common.SQL_COMPAT_MODE.fetchPropertyValue(properties);
        this.catalogDataverseMode = ADBConnection.getCatalogDataverseMode(properties, protocol.getErrorReporter());
        this.catalogIncludesSchemaless = (Boolean)ADBDriverProperty.Common.CATALOG_INCLUDES_SCHEMALESS.fetchPropertyValue(properties);
        this.initCatalogSchema(protocol, dataverseCanonicalName);
    }

    protected void initCatalogSchema(ADBProtocolBase protocol, String dataverseCanonicalName) throws SQLException {
        block0 : switch (this.catalogDataverseMode) {
            case CATALOG: {
                this.catalog = dataverseCanonicalName == null || dataverseCanonicalName.isEmpty() ? protocol.getDefaultDataverse() : dataverseCanonicalName;
                break;
            }
            case CATALOG_SCHEMA: {
                if (dataverseCanonicalName == null || dataverseCanonicalName.isEmpty()) {
                    this.catalog = protocol.getDefaultDataverse();
                    break;
                }
                String[] parts = dataverseCanonicalName.split("/");
                switch (parts.length) {
                    case 1: {
                        this.catalog = parts[0];
                        break block0;
                    }
                    case 2: {
                        this.catalog = parts[0];
                        this.schema = parts[1];
                        break block0;
                    }
                }
                throw protocol.getErrorReporter().errorInConnection(dataverseCanonicalName);
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void close() throws SQLException {
        this.closeImpl(null);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw this.getErrorReporter().errorParameterValueNotSupported("executor");
        }
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(new SQLPermission("callAbort"));
        }
        this.closeImpl(executor);
    }

    protected void closeImpl(Executor executor) throws SQLException {
        boolean wasClosed = this.closed.getAndSet(true);
        if (wasClosed) {
            return;
        }
        if (executor == null) {
            this.closeStatementsAndProtocol();
        } else {
            executor.execute(() -> {
                block2: {
                    try {
                        this.closeStatementsAndProtocol();
                    }
                    catch (SQLException e) {
                        if (!this.getLogger().isLoggable(Level.FINE)) break block2;
                        this.getLogger().log(Level.FINE, e.getMessage(), e);
                    }
                }
            });
        }
    }

    protected void closeStatementsAndProtocol() throws SQLException {
        SQLException err = null;
        try {
            this.closeRegisteredStatements();
        }
        catch (SQLException e) {
            err = e;
        }
        try {
            this.protocol.close();
        }
        catch (SQLException e) {
            if (err != null) {
                e.addSuppressed(err);
            }
            err = e;
        }
        if (err != null) {
            throw err;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw this.getErrorReporter().errorObjectClosed(Connection.class);
        }
    }

    @Override
    public boolean isValid(int timeoutSeconds) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        if (timeoutSeconds < 0) {
            throw this.getErrorReporter().errorParameterValueNotSupported("timeoutSeconds");
        }
        return this.protocol.ping(timeoutSeconds);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "setNetworkTimeout");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "getNetworkTimeout");
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        ADBMetaStatement metaStatement = this.getOrCreateMetaStatement();
        return this.createDatabaseMetaData(metaStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ADBMetaStatement getOrCreateMetaStatement() {
        ADBMetaStatement stmt = this.metaStatement;
        if (stmt == null) {
            ADBConnection aDBConnection = this;
            synchronized (aDBConnection) {
                stmt = this.metaStatement;
                if (stmt == null) {
                    stmt = this.createMetaStatement();
                    this.registerStatement(stmt);
                    this.metaStatement = stmt;
                }
            }
        }
        return stmt;
    }

    protected ADBMetaStatement createMetaStatement() {
        return new ADBMetaStatement(this);
    }

    protected ADBDatabaseMetaData createDatabaseMetaData(ADBMetaStatement metaStatement) {
        return new ADBDatabaseMetaData(metaStatement, this.databaseVersion);
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        return this.createStatementImpl();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        this.checkResultSetConfig(resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.createStatementImpl();
    }

    private void checkResultSetConfig(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        boolean ok;
        boolean bl = ok = resultSetType == 1003 && resultSetConcurrency == 1007;
        if (!ok) {
            throw this.getErrorReporter().errorParameterValueNotSupported("resultSetType/resultSetConcurrency");
        }
        if (resultSetHoldability != 1 && this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().log(Level.FINE, this.getErrorReporter().warningParameterValueNotSupported("ResultSetHoldability"));
        }
    }

    protected ADBStatement createStatementImpl() {
        ADBStatement stmt = new ADBStatement(this);
        this.registerStatement(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        return this.prepareStatementImpl(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        this.checkResultSetConfig(resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.prepareStatementImpl(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "prepareStatement");
    }

    private ADBPreparedStatement prepareStatementImpl(String sql) throws SQLException {
        ADBPreparedStatement stmt = new ADBPreparedStatement(this, sql);
        this.registerStatement(stmt);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "prepareCall");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "prepareCall");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "prepareCall");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        return sql;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.catalog;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        this.catalog = catalog;
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return this.schema;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        if (this.catalogDataverseMode == ADBDriverProperty.CatalogDataverseMode.CATALOG && schema != null && !schema.isEmpty()) {
            throw this.getErrorReporter().errorInConnection(schema);
        }
        this.schema = schema;
    }

    protected String getDataverseCanonicalName() {
        switch (this.catalogDataverseMode) {
            case CATALOG: {
                return this.catalog;
            }
            case CATALOG_SCHEMA: {
                String c = this.catalog;
                String s = this.schema;
                return s == null ? c : c + "/" + s;
            }
        }
        throw new IllegalStateException();
    }

    protected static ADBDriverProperty.CatalogDataverseMode getCatalogDataverseMode(Map<ADBDriverProperty, Object> properties, ADBErrorReporter errorReporter) throws SQLException {
        int mode = ((Number)ADBDriverProperty.Common.CATALOG_DATAVERSE_MODE.fetchPropertyValue(properties)).intValue();
        try {
            return ADBDriverProperty.CatalogDataverseMode.valueOf(mode);
        }
        catch (IllegalArgumentException e) {
            throw errorReporter.errorInConnection(String.valueOf(mode));
        }
    }

    private void registerStatement(ADBStatement stmt) {
        this.statements.add(Objects.requireNonNull(stmt));
    }

    void deregisterStatement(ADBStatement stmt) {
        this.statements.remove(Objects.requireNonNull(stmt));
    }

    private void closeRegisteredStatements() throws SQLException {
        ADBStatement statement;
        SQLException err = null;
        while ((statement = this.statements.poll()) != null) {
            try {
                statement.closeImpl(true, false);
            }
            catch (SQLException e) {
                if (err != null) {
                    e.addSuppressed(err);
                }
                err = e;
            }
        }
        if (err != null) {
            throw err;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return 2;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        switch (level) {
            case 2: {
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                if (!this.getLogger().isLoggable(Level.FINE)) break;
                this.getLogger().log(Level.FINE, this.getErrorReporter().warningParameterValueNotSupported("TransactionIsolationLevel"));
                break;
            }
            default: {
                throw this.getErrorReporter().errorParameterValueNotSupported("TransactionIsolationLevel");
            }
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return 1;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        switch (holdability) {
            case 1: {
                break;
            }
            case 2: {
                if (!this.getLogger().isLoggable(Level.FINE)) break;
                this.getLogger().log(Level.FINE, this.getErrorReporter().warningParameterValueNotSupported("Holdability"));
                break;
            }
            default: {
                throw this.getErrorReporter().errorParameterValueNotSupported("Holdability");
            }
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        throw this.getErrorReporter().errorIncompatibleMode("AutoCommit");
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        throw this.getErrorReporter().errorIncompatibleMode("AutoCommit");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "setSavepoint");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "setSavepoint");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "releaseSavepoint");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "rollback");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "createClob");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "createBlob");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "createNClob");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "createArrayOf");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "createStruct");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "createSQLXML");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        return Collections.emptyMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Connection.class, "setTypeMap");
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warning = null;
    }

    @Override
    protected ADBErrorReporter getErrorReporter() {
        return this.protocol.getErrorReporter();
    }

    protected Logger getLogger() {
        return this.protocol.getLogger();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return new Properties();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw this.getErrorReporter().errorClientInfoMethodNotSupported(Connection.class, "setClientInfo");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw this.getErrorReporter().errorClientInfoMethodNotSupported(Connection.class, "setClientInfo");
    }
}

