/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.basedriver.importer.core.event.structs;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.felix.upnp.basedriver.importer.core.MyCtrlPoint;
import org.apache.felix.upnp.basedriver.importer.core.event.message.FirstMessage;
import org.apache.felix.upnp.basedriver.importer.core.event.message.ListenerModified;
import org.apache.felix.upnp.basedriver.importer.core.event.structs.SidsListenersMaps;
import org.apache.felix.upnp.basedriver.importer.core.event.structs.StateVarsToNotify;
import org.apache.felix.upnp.basedriver.importer.core.event.structs.SubscriptionQueue;
import org.cybergarage.upnp.Service;
import org.osgi.service.upnp.UPnPEventListener;

public class Monitor {
    private Hashtable sidStateVars;
    private SidsListenersMaps sidListSid = new SidsListenersMaps();

    public Monitor() {
        this.sidStateVars = new Hashtable();
    }

    public synchronized void putStateVars(String sid, StateVarsToNotify vars) {
        this.sidStateVars.put(sid, vars);
        Vector listeners = this.sidListSid.getListenersFromSid(sid);
        if (listeners != null) {
            this.sidListSid.updateListeners(sid, vars.getDeviceID(), vars.getServiceID(), vars.getDictionary());
            this.sidListSid.setAlreadyFirst(sid, true);
        } else {
            this.sidListSid.setAlreadyFirst(sid, false);
        }
    }

    public synchronized void updateStateVars(String sid, Dictionary dic) {
        StateVarsToNotify vars = (StateVarsToNotify)this.sidStateVars.get(sid);
        if (vars != null) {
            vars.updateDic(dic);
            if (this.sidListSid.getAlreadyFirst(sid)) {
                this.sidListSid.updateListeners(sid, vars.getDeviceID(), vars.getServiceID(), dic);
            } else {
                boolean bool = this.sidListSid.updateListeners(sid, vars.getDeviceID(), vars.getServiceID(), vars.getDictionary());
                if (bool) {
                    this.sidListSid.setAlreadyFirst(sid, true);
                }
            }
        }
    }

    public synchronized void addListener(String sid, UPnPEventListener listener) {
        StateVarsToNotify vars = (StateVarsToNotify)this.sidStateVars.get(sid);
        if (vars != null) {
            listener.notifyUPnPEvent(vars.getDeviceID(), vars.getServiceID(), vars.getDictionary());
        }
        this.sidListSid.putSid2Listeners(sid, listener);
        this.sidListSid.putListener2Sids(listener, sid);
    }

    public synchronized void delListener(UPnPEventListener listener, MyCtrlPoint ctrl) {
        Vector sids = this.sidListSid.getSidsFromListener(listener);
        if (sids != null) {
            Iterator i = sids.iterator();
            while (i.hasNext()) {
                boolean ok;
                String sid = (String)i.next();
                Vector listeners = this.sidListSid.getListenersFromSid(sid);
                listeners.remove(listener);
                if (listeners.size() != 0) continue;
                Service service = ctrl.serviceFromSid(sid);
                if (service != null && !(ok = ctrl.unsubscribe(service))) {
                    service.clearSID();
                }
                this.sidListSid.setAlreadyFirst(sid, false);
                this.sidStateVars.remove(sid);
                i.remove();
            }
            this.sidListSid.removeListenerKey(listener);
        }
    }

    public synchronized void updateListener(ListenerModified msg, SubscriptionQueue subqueue, MyCtrlPoint ctrl) {
        int i;
        UPnPEventListener listener = msg.getListener();
        Vector newServices = msg.getNewServices();
        Vector<Service> subscribed = new Vector<Service>();
        Vector<Service> notSubscribed = new Vector<Service>();
        for (int i2 = 0; i2 < newServices.size(); ++i2) {
            Service ser = (Service)newServices.elementAt(i2);
            if (ser.isSubscribed()) {
                subscribed.add(ser);
                continue;
            }
            notSubscribed.add(ser);
        }
        Vector oldSids = this.sidListSid.getSidsFromListener(listener);
        if (oldSids == null) {
            return;
        }
        for (i = 0; i < notSubscribed.size(); ++i) {
            Service ser = (Service)notSubscribed.elementAt(i);
            subqueue.enqueue(new FirstMessage(ser, listener));
        }
        for (i = 0; i < oldSids.size(); ++i) {
            String oldSid = (String)oldSids.elementAt(i);
            if (subscribed.contains(oldSid)) continue;
            this.unsubscribeListenerForSid(oldSid, listener, ctrl);
        }
    }

    private void unsubscribeListenerForSid(String sid, UPnPEventListener listener, MyCtrlPoint ctrl) {
        Vector listeners = this.sidListSid.getListenersFromSid(sid);
        listeners.remove(listener);
        if (listeners.size() == 0) {
            boolean ok;
            Service service = ctrl.serviceFromSid(sid);
            if (service != null && !(ok = ctrl.unsubscribe(service))) {
                service.clearSID();
            }
            this.sidListSid.setAlreadyFirst(sid, false);
            this.sidStateVars.remove(sid);
        }
        Vector sids = this.sidListSid.getSidsFromListener(listener);
        sids.remove(sid);
        if (sids.size() == 0) {
            this.sidListSid.removeListenerKey(listener);
        }
    }

    public synchronized void delSid(String sid) {
        Vector listeners = this.sidListSid.getListenersFromSid(sid);
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.size(); ++i) {
            Vector sids = this.sidListSid.getSidsFromListener((UPnPEventListener)listeners.elementAt(i));
            sids.remove(sid);
        }
        this.sidListSid.removeSidKey(sid);
    }

    public synchronized void clearAll(String sid, Service service) {
        service.clearSID();
        this.delSid(sid);
        this.sidStateVars.remove(sid);
    }
}

