/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.FinalizeOnMaster;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.table.FileSystemCommitter;
import org.apache.flink.connector.file.table.FileSystemFactory;
import org.apache.flink.connector.file.table.OutputFormatFactory;
import org.apache.flink.connector.file.table.PartitionComputer;
import org.apache.flink.connector.file.table.PartitionTempFileManager;
import org.apache.flink.connector.file.table.PartitionWriter;
import org.apache.flink.connector.file.table.PartitionWriterFactory;
import org.apache.flink.connector.file.table.TableMetaStoreFactory;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputFileConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.util.Preconditions;

@Internal
public class FileSystemOutputFormat<T>
implements OutputFormat<T>,
FinalizeOnMaster,
Serializable {
    private static final long serialVersionUID = 1L;
    private final FileSystemFactory fsFactory;
    private final TableMetaStoreFactory msFactory;
    private final boolean overwrite;
    private final Path tmpPath;
    private final String[] partitionColumns;
    private final boolean dynamicGrouped;
    private final LinkedHashMap<String, String> staticPartitions;
    private final PartitionComputer<T> computer;
    private final OutputFormatFactory<T> formatFactory;
    private final OutputFileConfig outputFileConfig;
    private transient PartitionWriter<T> writer;
    private transient Configuration parameters;

    private FileSystemOutputFormat(FileSystemFactory fsFactory, TableMetaStoreFactory msFactory, boolean overwrite, Path tmpPath, String[] partitionColumns, boolean dynamicGrouped, LinkedHashMap<String, String> staticPartitions, OutputFormatFactory<T> formatFactory, PartitionComputer<T> computer, OutputFileConfig outputFileConfig) {
        this.fsFactory = fsFactory;
        this.msFactory = msFactory;
        this.overwrite = overwrite;
        this.tmpPath = tmpPath;
        this.partitionColumns = partitionColumns;
        this.dynamicGrouped = dynamicGrouped;
        this.staticPartitions = staticPartitions;
        this.formatFactory = formatFactory;
        this.computer = computer;
        this.outputFileConfig = outputFileConfig;
    }

    @Override
    public void finalizeGlobal(int parallelism) {
        try {
            FileSystemCommitter committer = new FileSystemCommitter(this.fsFactory, this.msFactory, this.overwrite, this.tmpPath, this.partitionColumns.length);
            committer.commitPartitions();
        }
        catch (Exception e) {
            throw new TableException("Exception in finalizeGlobal", e);
        }
        finally {
            try {
                this.fsFactory.create(this.tmpPath.toUri()).delete(this.tmpPath, true);
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void configure(Configuration parameters) {
        this.parameters = parameters;
    }

    @Override
    public void open(int taskNumber, int numTasks) throws IOException {
        try {
            PartitionTempFileManager fileManager = new PartitionTempFileManager(this.fsFactory, this.tmpPath, taskNumber, this.outputFileConfig);
            PartitionWriter.Context<T> context = new PartitionWriter.Context<T>(this.parameters, this.formatFactory);
            this.writer = PartitionWriterFactory.get(this.partitionColumns.length - this.staticPartitions.size() > 0, this.dynamicGrouped, this.staticPartitions).create(context, fileManager, this.computer);
        }
        catch (Exception e) {
            throw new TableException("Exception in open", e);
        }
    }

    @Override
    public void writeRecord(T record) {
        try {
            this.writer.write(record);
        }
        catch (Exception e) {
            throw new TableException("Exception in writeRecord", e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.writer.close();
        }
        catch (Exception e) {
            throw new TableException("Exception in close", e);
        }
    }

    public static class Builder<T> {
        private String[] partitionColumns;
        private OutputFormatFactory<T> formatFactory;
        private TableMetaStoreFactory metaStoreFactory;
        private Path tmpPath;
        private LinkedHashMap<String, String> staticPartitions = new LinkedHashMap();
        private boolean dynamicGrouped = false;
        private boolean overwrite = false;
        private FileSystemFactory fileSystemFactory = FileSystem::get;
        private PartitionComputer<T> computer;
        private OutputFileConfig outputFileConfig = new OutputFileConfig("", "");

        public Builder<T> setPartitionColumns(String[] partitionColumns) {
            this.partitionColumns = partitionColumns;
            return this;
        }

        public Builder<T> setStaticPartitions(LinkedHashMap<String, String> staticPartitions) {
            this.staticPartitions = staticPartitions;
            return this;
        }

        public Builder<T> setDynamicGrouped(boolean dynamicGrouped) {
            this.dynamicGrouped = dynamicGrouped;
            return this;
        }

        public Builder<T> setFormatFactory(OutputFormatFactory<T> formatFactory) {
            this.formatFactory = formatFactory;
            return this;
        }

        public Builder<T> setFileSystemFactory(FileSystemFactory fileSystemFactory) {
            this.fileSystemFactory = fileSystemFactory;
            return this;
        }

        public Builder<T> setMetaStoreFactory(TableMetaStoreFactory metaStoreFactory) {
            this.metaStoreFactory = metaStoreFactory;
            return this;
        }

        public Builder<T> setOverwrite(boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        public Builder<T> setTempPath(Path tmpPath) {
            this.tmpPath = tmpPath;
            return this;
        }

        public Builder<T> setPartitionComputer(PartitionComputer<T> computer) {
            this.computer = computer;
            return this;
        }

        public Builder<T> setOutputFileConfig(OutputFileConfig outputFileConfig) {
            this.outputFileConfig = outputFileConfig;
            return this;
        }

        public FileSystemOutputFormat<T> build() {
            Preconditions.checkNotNull(this.partitionColumns, "partitionColumns should not be null");
            Preconditions.checkNotNull(this.formatFactory, "formatFactory should not be null");
            Preconditions.checkNotNull(this.metaStoreFactory, "metaStoreFactory should not be null");
            Preconditions.checkNotNull(this.tmpPath, "tmpPath should not be null");
            Preconditions.checkNotNull(this.computer, "partitionComputer should not be null");
            return new FileSystemOutputFormat(this.fileSystemFactory, this.metaStoreFactory, this.overwrite, this.tmpPath, this.partitionColumns, this.dynamicGrouped, this.staticPartitions, this.formatFactory, this.computer, this.outputFileConfig);
        }
    }
}

