/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.iterative.io;

import java.io.IOException;
import org.apache.flink.runtime.operators.hash.CompactingHashTable;
import org.apache.flink.util.Collector;

public class SolutionSetUpdateOutputCollector<T>
implements Collector<T> {
    private final Collector<T> delegate;
    private final CompactingHashTable<T> solutionSet;

    public SolutionSetUpdateOutputCollector(CompactingHashTable<T> solutionSet) {
        this(solutionSet, null);
    }

    public SolutionSetUpdateOutputCollector(CompactingHashTable<T> solutionSet, Collector<T> delegate) {
        this.solutionSet = solutionSet;
        this.delegate = delegate;
    }

    @Override
    public void collect(T record) {
        try {
            this.solutionSet.insertOrReplaceRecord(record);
            if (this.delegate != null) {
                this.delegate.collect(record);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }
}

