/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

@Internal
public final class TupleSerializerSnapshot<T extends Tuple>
extends CompositeTypeSerializerSnapshot<T, TupleSerializer<T>> {
    private static final int VERSION = 2;
    private Class<T> tupleClass;

    public TupleSerializerSnapshot() {
        super(TupleSerializer.class);
    }

    TupleSerializerSnapshot(TupleSerializer<T> serializerInstance) {
        super(serializerInstance);
        this.tupleClass = Preconditions.checkNotNull(serializerInstance.getTupleClass(), "tuple class can not be NULL");
    }

    TupleSerializerSnapshot(Class<T> tupleClass) {
        super(TupleSerializer.class);
        this.tupleClass = Preconditions.checkNotNull(tupleClass, "tuple class can not be NULL");
    }

    @Override
    protected int getCurrentOuterSnapshotVersion() {
        return 2;
    }

    @Override
    protected TypeSerializer<?>[] getNestedSerializers(TupleSerializer<T> outerSerializer) {
        return outerSerializer.getFieldSerializers();
    }

    @Override
    protected TupleSerializer<T> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
        Preconditions.checkState(this.tupleClass != null, "tuple class can not be NULL");
        return new TupleSerializer<T>(this.tupleClass, nestedSerializers);
    }

    @Override
    protected void writeOuterSnapshot(DataOutputView out) throws IOException {
        Preconditions.checkState(this.tupleClass != null, "tuple class can not be NULL");
        out.writeUTF(this.tupleClass.getName());
    }

    @Override
    protected void readOuterSnapshot(int readOuterSnapshotVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        this.tupleClass = InstantiationUtil.resolveClassByName(in, userCodeClassLoader);
    }
}

