/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.kafka.converter;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.pdx.JSONFormatter;
import org.apache.geode.pdx.PdxInstance;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.storage.Converter;

public class JsonPdxConverter
implements Converter {
    public static final String JSON_TYPE_ANNOTATION = "\"@type\"";
    public static final String ADD_TYPE_ANNOTATION_TO_JSON = "add-type-annotation-to-json";
    private final Map<String, String> internalConfig = new HashMap<String, String>();

    public void configure(Map<String, ?> configs, boolean isKey) {
        if (configs != null) {
            configs.forEach((key, value) -> this.internalConfig.put((String)key, (String)value));
        }
    }

    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        PdxInstance pdxInstanceValue = (PdxInstance)value;
        byte[] jsonBytes = this.getJsonBytes(pdxInstanceValue);
        if (!this.shouldAddTypeAnnotation()) {
            return jsonBytes;
        }
        String jsonString = new String(jsonBytes);
        if (!jsonString.contains(JSON_TYPE_ANNOTATION)) {
            jsonString = jsonString.replaceFirst("\\{", "{\"@type\" : \"" + pdxInstanceValue.getClassName() + "\",");
        }
        return jsonString.getBytes();
    }

    public SchemaAndValue toConnectData(String topic, byte[] value) {
        return new SchemaAndValue(null, (Object)JSONFormatter.fromJSON((byte[])value));
    }

    byte[] getJsonBytes(PdxInstance pdxInstanceValue) {
        return JSONFormatter.toJSONByteArray((PdxInstance)pdxInstanceValue);
    }

    boolean shouldAddTypeAnnotation() {
        return Boolean.parseBoolean(this.internalConfig.get(ADD_TYPE_ANNOTATION_TO_JSON));
    }

    public Map<String, String> getInternalConfig() {
        return this.internalConfig;
    }
}

