/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.server.ServerLoad;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.GridAdvisor;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class CacheServerAdvisor
extends GridAdvisor {
    private CacheServerAdvisor(DistributionAdvisee server) {
        super(server);
    }

    public static CacheServerAdvisor createCacheServerAdvisor(DistributionAdvisee server) {
        CacheServerAdvisor advisor = new CacheServerAdvisor(server);
        advisor.initialize();
        return advisor;
    }

    public String toString() {
        return "CacheServerAdvisor for " + this.getAdvisee().getFullPath();
    }

    @Override
    protected DistributionAdvisor.Profile instantiateProfile(InternalDistributedMember memberId, int version) {
        return new CacheServerProfile(memberId, version);
    }

    public static class CacheServerProfile
    extends GridAdvisor.GridProfile {
        private String[] groups;
        private int maxConnections;
        private ServerLoad initialLoad;
        private long loadPollInterval;

        public CacheServerProfile() {
        }

        public CacheServerProfile(InternalDistributedMember memberId, int version) {
            super(memberId, version);
        }

        public CacheServerProfile(CacheServerProfile toCopy) {
            super(toCopy);
            this.groups = toCopy.groups;
        }

        public String[] getGroups() {
            return this.groups;
        }

        public void setGroups(String[] groups) {
            this.groups = groups;
        }

        public ServerLoad getInitialLoad() {
            return this.initialLoad;
        }

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
        }

        public void setInitialLoad(ServerLoad initialLoad) {
            this.initialLoad = initialLoad;
        }

        public long getLoadPollInterval() {
            return this.loadPollInterval;
        }

        public void setLoadPollInterval(long v) {
            this.loadPollInterval = v;
        }

        @Override
        public void processIncoming(ClusterDistributionManager dm, String adviseePath, boolean removeProfile, boolean exchangeProfiles, List<DistributionAdvisor.Profile> replyProfiles) {
            this.tellLocalControllers(removeProfile, exchangeProfiles, replyProfiles);
            this.tellLocalBridgeServers(dm.getCache(), removeProfile, exchangeProfiles, replyProfiles);
        }

        @Override
        public int getDSFID() {
            return -91;
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeStringArray(this.groups, out);
            out.writeInt(this.maxConnections);
            InternalDataSerializer.invokeToData(this.initialLoad, out);
            out.writeLong(this.getLoadPollInterval());
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.groups = DataSerializer.readStringArray(in);
            this.maxConnections = in.readInt();
            this.initialLoad = new ServerLoad();
            InternalDataSerializer.invokeFromData(this.initialLoad, in);
            this.setLoadPollInterval(in.readLong());
        }

        @Override
        public StringBuilder getToStringHeader() {
            return new StringBuilder("BridgeServerProfile");
        }

        @Override
        public void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
            if (this.groups != null) {
                sb.append("; groups=" + Arrays.asList(this.groups));
                sb.append("; maxConnections=" + this.maxConnections);
                sb.append("; initialLoad=" + this.initialLoad);
                sb.append("; loadPollInterval=" + this.getLoadPollInterval());
            }
        }
    }
}

