/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.operation;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.lang.Identifiable;
import org.apache.geode.management.api.ClusterManagementOperation;
import org.apache.geode.management.runtime.OperationResult;

@Experimental
public class OperationHistoryManager {
    private final ConcurrentMap<String, OperationInstance> history = new ConcurrentHashMap<String, OperationInstance>();
    private final long keepCompletedMillis;

    public OperationHistoryManager() {
        this(2L, TimeUnit.HOURS);
    }

    public OperationHistoryManager(long keepCompleted, TimeUnit timeUnit) {
        this.keepCompletedMillis = timeUnit.toMillis(keepCompleted);
    }

    <A extends ClusterManagementOperation<V>, V extends OperationResult> OperationInstance<A, V> getOperationInstance(String opId) {
        this.expireHistory();
        return (OperationInstance)this.history.get(opId);
    }

    private void expireHistory() {
        long expirationDate = this.now() - this.keepCompletedMillis;
        Set<String> expiredKeys = this.history.entrySet().stream().filter(e -> OperationHistoryManager.isExpired(expirationDate, (OperationInstance)e.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
        expiredKeys.forEach(this.history::remove);
    }

    long now() {
        return System.currentTimeMillis();
    }

    private static boolean isExpired(long expirationDate, OperationInstance<?, ?> operationInstance) {
        long endTime;
        CompletableFuture<Date> futureOperationEnded = operationInstance.getFutureOperationEnded();
        if (!futureOperationEnded.isDone()) {
            return false;
        }
        try {
            endTime = futureOperationEnded.get().getTime();
        }
        catch (ExecutionException ignore) {
            return false;
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
            return false;
        }
        return endTime <= expirationDate;
    }

    public <A extends ClusterManagementOperation<V>, V extends OperationResult> OperationInstance<A, V> save(OperationInstance<A, V> operationInstance) {
        String opId = operationInstance.getId();
        CompletableFuture<V> future = operationInstance.getFutureResult();
        future.whenComplete((result, exception) -> operationInstance.setOperationEnded(new Date()));
        this.history.put(opId, operationInstance);
        this.expireHistory();
        return operationInstance;
    }

    <A extends ClusterManagementOperation<V>, V extends OperationResult> List<OperationInstance<A, V>> listOperationInstances(A opType) {
        this.expireHistory();
        return this.history.values().stream().filter(oi -> opType.getClass().isInstance(oi.getOperation())).map(oi -> oi).collect(Collectors.toList());
    }

    public static class OperationInstance<A extends ClusterManagementOperation<V>, V extends OperationResult>
    implements Identifiable<String> {
        private final CompletableFuture<V> future;
        private final String opId;
        private final A operation;
        private final Date operationStart;
        private final CompletableFuture<Date> futureOperationEnded;
        private String operator;

        public OperationInstance(CompletableFuture<V> future, String opId, A operation, Date operationStart) {
            this.future = future;
            this.opId = opId;
            this.operation = operation;
            this.operationStart = operationStart;
            this.futureOperationEnded = new CompletableFuture();
        }

        public String getId() {
            return this.opId;
        }

        public CompletableFuture<V> getFutureResult() {
            return this.future;
        }

        public A getOperation() {
            return this.operation;
        }

        public Date getOperationStart() {
            return this.operationStart;
        }

        public CompletableFuture<Date> getFutureOperationEnded() {
            return this.futureOperationEnded;
        }

        public void setOperationEnded(Date operationEnded) {
            this.futureOperationEnded.complete(operationEnded);
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }
    }
}

