/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.operation;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Cache;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.management.api.ClusterManagementOperation;
import org.apache.geode.management.internal.operation.OperationHistoryManager;
import org.apache.geode.management.internal.operation.RebalanceOperationPerformer;
import org.apache.geode.management.internal.operation.TaggedWithOperator;
import org.apache.geode.management.operation.RebalanceOperation;
import org.apache.geode.management.runtime.OperationResult;

@Experimental
public class OperationManager
implements AutoCloseable {
    private final Map<Class<? extends ClusterManagementOperation>, BiFunction> performers;
    private final OperationHistoryManager historyManager;
    private final Executor executor;
    private final InternalCache cache;

    public OperationManager(InternalCache cache, OperationHistoryManager historyManager) {
        this.cache = cache;
        this.historyManager = historyManager;
        this.executor = LoggingExecutors.newThreadOnEachExecute((String)"CMSOpPerformer");
        this.performers = new ConcurrentHashMap<Class<? extends ClusterManagementOperation>, BiFunction>();
        this.registerOperation(RebalanceOperation.class, RebalanceOperationPerformer::perform);
    }

    public <A extends ClusterManagementOperation<V>, V extends OperationResult> void registerOperation(Class<A> operationClass, BiFunction<Cache, A, V> operationPerformer) {
        this.performers.put(operationClass, operationPerformer);
    }

    public <A extends ClusterManagementOperation<V>, V extends OperationResult> OperationHistoryManager.OperationInstance<A, V> submit(A op) {
        String opId = UUID.randomUUID().toString();
        BiFunction performer = this.getPerformer(op);
        if (performer == null) {
            throw new IllegalArgumentException(String.format("%s is not supported.", op.getClass().getSimpleName()));
        }
        CompletableFuture<OperationResult> future = CompletableFuture.supplyAsync(() -> (OperationResult)performer.apply(this.cache, op), this.executor);
        OperationHistoryManager.OperationInstance<A, OperationResult> inst = new OperationHistoryManager.OperationInstance<A, OperationResult>(future, opId, op, new Date());
        return this.historyManager.save(inst);
    }

    private <C extends Cache, A extends ClusterManagementOperation<V>, V extends OperationResult> BiFunction<C, A, V> getPerformer(A op) {
        Class<?> aClass = op.getClass();
        if (op instanceof TaggedWithOperator && ClusterManagementOperation.class.isAssignableFrom(aClass.getSuperclass())) {
            aClass = aClass.getSuperclass();
        }
        return this.performers.get(aClass);
    }

    public <A extends ClusterManagementOperation<V>, V extends OperationResult> OperationHistoryManager.OperationInstance<A, V> getOperationInstance(String opId) {
        return this.historyManager.getOperationInstance(opId);
    }

    public <A extends ClusterManagementOperation<V>, V extends OperationResult> List<OperationHistoryManager.OperationInstance<A, V>> listOperationInstances(A opType) {
        return this.historyManager.listOperationInstances(opType);
    }

    @Override
    public void close() {
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdownNow();
        }
    }
}

