/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context;

import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.inject.Singleton;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.CustomPassivatingContextImpl;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ContextsService;

public final class ContextFactory {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(ContextFactory.class);
    private final WebBeansContext webBeansContext;
    private ContextsService contextsService = null;

    public ContextFactory(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    private ContextsService getContextsService() {
        if (this.contextsService == null) {
            this.contextsService = this.webBeansContext.getService(ContextsService.class);
        }
        return this.contextsService;
    }

    public void initRequestContext(Object request) {
        try {
            ContextsService contextService = this.getContextsService();
            contextService.startContext(RequestScoped.class, request);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public Context getCustomContext(Context context) {
        if (this.webBeansContext.getBeanManagerImpl().isPassivatingScope(context.getScope())) {
            return new CustomPassivatingContextImpl(this.webBeansContext.getSerializableBeanVault(), context);
        }
        return context;
    }

    public void destroyRequestContext(Object request) {
        ContextsService contextService = this.getContextsService();
        contextService.endContext(RequestScoped.class, request);
    }

    public void initSessionContext(Object session) {
        try {
            ContextsService contextService = this.getContextsService();
            contextService.startContext(SessionScoped.class, session);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void destroySessionContext(Object session) {
        ContextsService contextService = this.getContextsService();
        contextService.endContext(SessionScoped.class, session);
    }

    public void initApplicationContext(Object parameter) {
        try {
            ContextsService contextService = this.getContextsService();
            contextService.startContext(ApplicationScoped.class, parameter);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void destroyApplicationContext(Object parameter) {
        ContextsService contextService = this.getContextsService();
        contextService.endContext(ApplicationScoped.class, parameter);
    }

    public void initSingletonContext(Object parameter) {
        try {
            ContextsService contextService = this.getContextsService();
            contextService.startContext(Singleton.class, parameter);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void destroySingletonContext(Object parameter) {
        ContextsService contextService = this.getContextsService();
        contextService.endContext(Singleton.class, parameter);
    }

    public void initConversationContext(Object context) {
        try {
            ContextsService contextService = this.getContextsService();
            contextService.startContext(ConversationScoped.class, context);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void destroyConversationContext() {
        ContextsService contextService = this.getContextsService();
        contextService.endContext(ConversationScoped.class, null);
    }

    public Context getStandardContext(Class<? extends Annotation> scopeType) {
        ContextsService contextService = this.getContextsService();
        return contextService.getCurrentContext(scopeType);
    }
}

