/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.proxy;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.webbeans.exception.ProxyGenerationException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;

public class Unsafe {
    private Object unsafe;
    private Method unsafeAllocateInstance;
    private final AtomicReference<Method> unsafeDefineClass = new AtomicReference();

    public Unsafe() {
        final Class<?> unsafeClass = this.getUnsafeClass();
        this.unsafe = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Field field = unsafeClass.getDeclaredField("theUnsafe");
                    field.setAccessible(true);
                    return field.get(null);
                }
                catch (Exception e) {
                    WebBeansLoggerFacade.getLogger(Unsafe.class).info("Cannot get sun.misc.Unsafe - will use newInstance() instead!");
                    return null;
                }
            }
        });
        if (this.unsafe != null) {
            this.unsafeAllocateInstance = AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    try {
                        Method mtd = unsafeClass.getDeclaredMethod("allocateInstance", Class.class);
                        mtd.setAccessible(true);
                        return mtd;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
        }
    }

    public <T> Class<T> defineAndLoadClass(ClassLoader classLoader, String proxyName, byte[] proxyBytes) throws ProxyGenerationException {
        Class<?> clazz = classLoader.getClass();
        AccessibleObject defineClassMethod = null;
        do {
            try {
                defineClassMethod = clazz.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        } while (defineClassMethod == null && clazz != Object.class);
        if (defineClassMethod != null && !defineClassMethod.isAccessible()) {
            try {
                ((Method)defineClassMethod).setAccessible(true);
            }
            catch (RuntimeException re) {
                defineClassMethod = null;
            }
        }
        try {
            Class definedClass = defineClassMethod != null ? (Class)((Method)defineClassMethod).invoke(classLoader, proxyName, proxyBytes, 0, proxyBytes.length) : (Class)this.unsafeDefineClass().invoke(this.unsafe, proxyName, proxyBytes, 0, proxyBytes.length, classLoader, null);
            return Class.forName(definedClass.getName(), true, classLoader);
        }
        catch (InvocationTargetException le) {
            if (LinkageError.class.isInstance(le.getCause())) {
                try {
                    return Class.forName(proxyName.replace('/', '.'), true, classLoader);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            throw new ProxyGenerationException(le.getCause());
        }
        catch (Throwable e) {
            throw new ProxyGenerationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method unsafeDefineClass() {
        Method value = this.unsafeDefineClass.get();
        if (value == null) {
            Unsafe unsafe = this;
            synchronized (unsafe) {
                final Class<?> unsafeClass = this.getUnsafeClass();
                value = AccessController.doPrivileged(new PrivilegedAction<Method>(){

                    @Override
                    public Method run() {
                        try {
                            return unsafeClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
                        }
                        catch (Exception e) {
                            throw new IllegalStateException("Cannot get Unsafe.defineClass or equivalent", e);
                        }
                    }
                });
                this.unsafeDefineClass.compareAndSet(null, value);
            }
        }
        return value;
    }

    public <T> T unsafeNewInstance(Class<T> clazz) {
        try {
            if (this.unsafeAllocateInstance != null) {
                return (T)this.unsafeAllocateInstance.invoke(this.unsafe, clazz);
            }
            try {
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to allocateInstance of Proxy class " + clazz.getName(), e);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to allocateInstance of Proxy class " + clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException() != null ? e.getTargetException() : e;
            throw new IllegalStateException("Failed to allocateInstance of Proxy class " + clazz.getName(), throwable);
        }
    }

    private Class<?> getUnsafeClass() {
        Class unsafeClass;
        try {
            unsafeClass = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    try {
                        return Thread.currentThread().getContextClassLoader().loadClass("sun.misc.Unsafe");
                    }
                    catch (Exception e) {
                        try {
                            return ClassLoader.getSystemClassLoader().loadClass("sun.misc.Unsafe");
                        }
                        catch (ClassNotFoundException e1) {
                            throw new IllegalStateException("Cannot get sun.misc.Unsafe", e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get sun.misc.Unsafe class", e);
        }
        return unsafeClass;
    }
}

