/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms;

import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sling.api.resource.Resource;

public class ResourceTree {
    private Resource root;

    public static Stream<ResourceTree> stream(Resource resource) {
        return new ResourceTree(resource).streamTree();
    }

    public static Stream<ResourceTree> stream(Resource resource, String filterType) {
        return new ResourceTree(resource).streamTree(filterType);
    }

    public static Stream<ResourceTree> stream(Resource resource, Predicate<Resource> filterTraversal, Predicate<ResourceTree> filterInclude) {
        return new ResourceTree(resource).streamTree(filterTraversal, filterInclude);
    }

    private ResourceTree(Resource root) {
        this.root = root;
    }

    public Resource getResource() {
        return this.root;
    }

    private Stream<ResourceTree> streamTree() {
        return this.streamTree(r -> true, rt -> true);
    }

    private Stream<ResourceTree> streamTree(String filterType) {
        return this.streamTree(r -> filterType.equals(r.getResourceType()), rt -> true);
    }

    private Stream<ResourceTree> streamTree(Predicate<Resource> filterTraversal, Predicate<ResourceTree> filterInclude) {
        return Stream.concat(Stream.of(this).filter(rt -> filterTraversal.test(rt.getResource())), StreamSupport.stream(this.root.getChildren().spliterator(), false).filter(filterTraversal).map(ResourceTree::new).flatMap(rt -> rt.streamTree(filterTraversal, filterInclude))).filter(filterInclude);
    }
}

