/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.optimization;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.scripting.sightly.compiler.commands.AbstractCommandVisitor;
import org.apache.sling.scripting.sightly.compiler.commands.Command;
import org.apache.sling.scripting.sightly.compiler.commands.Conditional;
import org.apache.sling.scripting.sightly.compiler.commands.Loop;
import org.apache.sling.scripting.sightly.compiler.commands.OutputVariable;
import org.apache.sling.scripting.sightly.compiler.commands.Procedure;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.VariableFinder;

public class CommandVariableUsage
extends AbstractCommandVisitor {
    private ArrayList<String> variables = new ArrayList();

    public static List<String> extractVariables(Command command) {
        CommandVariableUsage cvu = new CommandVariableUsage();
        command.accept(cvu);
        return cvu.variables;
    }

    @Override
    public void visit(Conditional.Start conditionalStart) {
        this.variables.add(conditionalStart.getVariable());
    }

    @Override
    public void visit(VariableBinding.Start variableBindingStart) {
        this.addFromExpression(variableBindingStart.getExpression());
    }

    @Override
    public void visit(VariableBinding.Global globalAssignment) {
        this.addFromExpression(globalAssignment.getExpression());
    }

    private void addFromExpression(ExpressionNode node) {
        this.variables.addAll(VariableFinder.findVariables(node));
    }

    @Override
    public void visit(OutputVariable outputVariable) {
        this.variables.add(outputVariable.getVariableName());
    }

    @Override
    public void visit(Loop.Start loopStart) {
        this.variables.add(loopStart.getListVariable());
    }

    @Override
    public void visit(Procedure.Call procedureCall) {
        this.variables.add(procedureCall.getTemplateVariable());
        this.variables.add(procedureCall.getArgumentsVariable());
    }
}

