#!BPY
"""
Name: 'Ipo_Stretcher'
Blender: 2.48
Group: 'Animation'
Tooltip: 'A tool designed to stretch IPO curves in time'
"""
__author__ = "Gwenael Le Page"
__url__ = ("http://wiki.blender.org/index.php/Extensions:Py/Scripts/Manual/Animation/IPOStretcher")
__version__ = "0.10 - 2009"

__bpydoc__ = """\
This script scales the ipo to stretch time.

"""

#"THIS IS NOT A FINAL VERSION OF THE SCRIPT !"

# -------------------------------------------------------------------------- 
# ***** BEGIN GPL LICENSE BLOCK ***** 
# 
# This program is free software; you can redistribute it and/or 
# modify it under the terms of the GNU General Public License 
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version. 
# 
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software Foundation, 
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
# 
# ***** END GPL LICENCE BLOCK ***** 
# -------------------------------------------------------------------------- 

#For questions and/or feature requests, contact Gwenouille at BlenderArtists.org

import Blender
from Blender import Ipo,IpoCurve
from Blender import Object,Window
from Blender.sys import *
from Blender.Draw import *

path=Blender.Get("datadir")
if not path:
	errmsg = "\nNo bpydata/ dir found! It should be in Blender's home dir."
	raise IOError, errmsg
settings=open(join(path,'IPOStretcherSettings.txt'),'r')
text=settings.readlines()

global stretchoffset,stretchfactor

stretchoffset=Create(eval(text[0]))
stretchfactor=Create(eval(text[1]))
all=Create(0)
settings.close()

elements=[]
elements.append(("Offset:",stretchoffset,-1000,1000,"Around what frame will the effect take place ?"))
elements.append(("Factor:",stretchfactor,-100.0,100.0,">1 slows down, <1 speeds up"))
elements.append(("All ?",all,"Change all Ipos in the scen if toggled"))
PupBlock=PupBlock("IPO Stretcher",elements)


def StretchIPO():
	print '\n################ IPO Stretcher 1_0 ####################\n'

	listofIPOs=[]
	selObjMat=[]
	if all==1:
		listofIPOs=(Blender.Ipo.Get())
		print listofIPOs
	else:
		selObj=Blender.Object.GetSelected()
		print len(selObj),'object(s) selected :'
		if len(selObj)==0:
			PupMenu("Select at least one object !")
		else:
			for obj in selObj:
				if obj.ipo:
					if obj.ipo not in listofIPOs:
						listofIPOs.append(obj.ipo)  #Object's IPOs
						
				mats=obj.getMaterials()
				for mat in mats:
					if mat not in selObjMat:
						selObjMat.append(mat)		#Object's Materieal IPOs
				
				if obj.type=='Mesh':							#Active object is a mesh
					selMe=obj.getData(False,True)
					selMeMat=selMe.materials
					for mat in selMeMat:
						if mat not in selObjMat:
							selObjMat.append(mat)
				elif obj.type=='Curve':						#Active object is a curve
					selCu=obj.data
					selCuMat=selCu.materials	
					for mat in selCuMat:
						if mat not in selObjMat:
							selObjMat.append(mat)	
				elif obj.type=='MBall':						#Active object is a metaball
					selMet=obj.data
					selMetMat=selMet.materials	
					for mat in selMetMat:
						if mat not in selObjMat:
							selObjMat.append(mat)
				
				
				
				
				
			for mat in selObjMat:
				if mat.ipo:
					if mat.ipo not in listofIPOs:
						listofIPOs.append(mat.ipo)
			print len(listofIPOs),' set(s) of IPO curves to work on'
			print listofIPOs
	for ipo in listofIPOs:
			for curve in ipo.curves:
				if stretchfactor.val>=0:
					for bp in curve.bezierPoints:
						bp.vec=[[stretchfactor.val*(bp.vec[0][0]-1)+1+stretchoffset.val,bp.vec[0][1],bp.vec[0][2]],[stretchfactor.val*(bp.vec[1][0]-1)+1+stretchoffset.val,bp.vec[1][1],bp.vec[1][2]],[stretchfactor.val*bp.vec[2][0]+stretchoffset.val,(bp.vec[2][1]-1)+1,bp.vec[2][2]]]
				elif stretchfactor.val<0:
					for bp in curve.bezierPoints:
						bp.vec=[[stretchfactor.val*bp.vec[2][0]+2*stretchoffset.val,bp.vec[2][1],bp.vec[2][2]],[stretchfactor.val*bp.vec[1][0]+2*stretchoffset.val,bp.vec[1][1],bp.vec[1][2]],[stretchfactor.val*bp.vec[0][0]+2*stretchoffset.val,bp.vec[0][1],bp.vec[0][2]]]
				curve.recalc()
			for curve in ipo.curves:
				curve.recalc()
	print 'Job completed: these IPOs have been stretched by a factor of ',stretchfactor.val,' and moved horizontally by an amout of ',stretchoffset.val,' frames.\n'
	Draw()
	
settings=open(join(path,'IPOStretcherSettings.txt'),'w')
seq=[str(stretchoffset.val)+'\n',str(stretchfactor)]
settings.writelines(seq)
settings.close()

StretchIPO()