# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

"""
Submodule containing all Freestyle types
"""

# module members
from _freestyle import (
    AdjacencyIterator,
    BBox,
    BinaryPredicate0D,
    BinaryPredicate1D,
    Chain,
    ChainingIterator,
    Curve,
    CurvePoint,
    CurvePointIterator,
    FEdge,
    FEdgeSharp,
    FEdgeSmooth,
    Id,
    IntegrationType,
    Interface0D,
    Interface0DIterator,
    Interface1D,
    Iterator,
    Material,
    MediumType,
    Nature,
    Noise,
    NonTVertex,
    Operators,
    SShape,
    SVertex,
    SVertexIterator,
    Stroke,
    StrokeAttribute,
    StrokeShader,
    StrokeVertex,
    StrokeVertexIterator,
    TVertex,
    UnaryFunction0D,
    UnaryFunction0DDouble,
    UnaryFunction0DEdgeNature,
    UnaryFunction0DFloat,
    UnaryFunction0DId,
    UnaryFunction0DMaterial,
    UnaryFunction0DUnsigned,
    UnaryFunction0DVec2f,
    UnaryFunction0DVec3f,
    UnaryFunction0DVectorViewShape,
    UnaryFunction0DViewShape,
    UnaryFunction1D,
    UnaryFunction1DDouble,
    UnaryFunction1DEdgeNature,
    UnaryFunction1DFloat,
    UnaryFunction1DUnsigned,
    UnaryFunction1DVec2f,
    UnaryFunction1DVec3f,
    UnaryFunction1DVectorViewShape,
    UnaryFunction1DVoid,
    UnaryPredicate0D,
    UnaryPredicate1D,
    ViewEdge,
    ViewEdgeIterator,
    ViewMap,
    ViewShape,
    ViewVertex,
    orientedViewEdgeIterator,
    )
