/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.HasAttributeFilter;
import org.htmlparser.filters.OrFilter;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.videolan.vlma.Data;
import org.videolan.vlma.IpBank;
import org.videolan.vlma.ProgramFactory;
import org.videolan.vlma.VLMaService;
import org.videolan.vlma.daemon.Daemon;
import org.videolan.vlma.dao.VLMaDao;
import org.videolan.vlma.model.Command;
import org.videolan.vlma.model.DTTChannel;
import org.videolan.vlma.model.FilesChannel;
import org.videolan.vlma.model.Media;
import org.videolan.vlma.model.Program;
import org.videolan.vlma.model.SatChannel;
import org.videolan.vlma.model.Satellite;
import org.videolan.vlma.model.Server;
import org.videolan.vlma.model.StreamChannel;
import org.videolan.vlma.model.StreamingStrategy;
import org.videolan.vlma.order.CommandLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataImpl
implements Data {
    private static final Logger logger = Logger.getLogger(DataImpl.class);
    private CommandLogger commandLogger;
    private Configuration configuration;
    private Daemon daemon;
    private IpBank ipBank;
    private ProgramFactory programFactory;
    private VLMaDao vlmaDao;
    private VLMaService vlmaService;

    public void reload() {
        this.daemon.reload();
    }

    public void stop() {
        this.daemon.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key) {
        Configuration configuration = this.configuration;
        synchronized (configuration) {
            return this.configuration.getString(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getInt(String key) {
        Configuration configuration = this.configuration;
        synchronized (configuration) {
            return this.configuration.getInt(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getList(String key) {
        Configuration configuration = this.configuration;
        synchronized (configuration) {
            return this.configuration.getList(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String key, Object value) {
        Configuration configuration = this.configuration;
        synchronized (configuration) {
            this.configuration.setProperty(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProperty(String key) {
        Configuration configuration = this.configuration;
        synchronized (configuration) {
            this.configuration.clearProperty(key);
        }
    }

    public List<Media> getMedias() {
        return this.vlmaDao.getMedias();
    }

    public List<Satellite> getSatellites() {
        return this.vlmaDao.getSatellites();
    }

    public List<Server> getServers() {
        return this.vlmaDao.getServers();
    }

    public Media getMedia(int id) {
        return this.vlmaDao.getMedia(id);
    }

    public Satellite getSatellite(int id) {
        return this.vlmaDao.getSatellite(id);
    }

    public Server getServer(int id) {
        return this.vlmaDao.getServer(id);
    }

    public void update(Media media) {
        Media m = this.vlmaDao.getMedia(media.getId());
        if (m.getProgram() != null && m.getProgram().getStreamingStrategy().getProtocol().equals((Object)StreamingStrategy.Protocol.UDP_MULTICAST) && (media.getProgram() == null || !media.getProgram().getStreamingStrategy().getProtocol().equals((Object)StreamingStrategy.Protocol.UDP_MULTICAST))) {
            this.ipBank.releaseIp(m.getProgram().getIp());
        } else if (media.getProgram() != null && (m.getProgram() == null || !m.getProgram().getStreamingStrategy().getProtocol().equals((Object)StreamingStrategy.Protocol.UDP_MULTICAST)) && media.getProgram().getStreamingStrategy().getProtocol().equals((Object)StreamingStrategy.Protocol.UDP_MULTICAST)) {
            media.getProgram().setIp(this.ipBank.getIp());
        }
        if (media.getProgram() != null) {
            String sapGroupId = null;
            if (media instanceof FilesChannel) {
                sapGroupId = "vlma.announcement.sap.files.group";
            } else if (media instanceof StreamChannel) {
                sapGroupId = "vlma.announcement.sap.stream.group";
            } else if (media instanceof DTTChannel) {
                sapGroupId = "vlma.announcement.sap.dtt.group";
            } else if (media instanceof SatChannel) {
                String category = ((SatChannel)m).getCategory();
                sapGroupId = "R-DIG".equals(category) || "R-DIG-CRYPT".equals(category) ? "vlma.announcement.sap.radio.group" : "vlma.announcement.sap.satellite.group";
            }
            if (sapGroupId != null) {
                media.getProgram().setSapGroup(this.configuration.getString(sapGroupId));
            }
        }
        this.vlmaDao.update(media);
    }

    public void update(Satellite satellite) {
        this.vlmaDao.update(satellite);
    }

    public void update(Server server) {
        this.vlmaDao.update(server);
    }

    public void add(Media media) {
        this.vlmaDao.add(media);
    }

    public void add(Satellite satellite) {
        this.vlmaDao.add(satellite);
    }

    public void add(Server server) {
        this.vlmaDao.add(server);
    }

    public void remove(Media media) {
        this.vlmaDao.remove(media);
    }

    public void remove(Satellite satellite) {
        this.vlmaDao.remove(satellite);
    }

    public void remove(Server server) {
        this.vlmaDao.remove(server);
    }

    public String getUrlOfProgram(Program program) {
        if (program != null) {
            if (program.getStreamingStrategy().getProtocol().equals((Object)StreamingStrategy.Protocol.HTTP)) {
                return "http://" + program.getPlayer().getHostAddress() + ":" + this.configuration.getInt("vlma.streaming.http.port") + "/" + program.hashCode();
            }
            if (program.getStreamingStrategy().getProtocol().equals((Object)StreamingStrategy.Protocol.UDP_MULTICAST)) {
                return "udp://@" + program.getIp().getHostAddress();
            }
        }
        return null;
    }

    public Program newProgram() {
        return this.programFactory.newProgram();
    }

    private static String htmlCellExtract(NodeList nodes, int column, int row, int maxRow) {
        String result = "";
        if (maxRow == 0) {
            Node text = nodes.elementAt(column);
            result = text.toPlainTextString();
        } else {
            TagNameFilter brTagFilter = new TagNameFilter("br");
            NodeList breakLines = nodes.elementAt(column).getChildren().extractAllNodesThatMatch((NodeFilter)brTagFilter);
            if (breakLines.size() == maxRow) {
                if (row == 0) {
                    Node text = breakLines.elementAt(0).getPreviousSibling();
                    while (!(text instanceof TextNode) || "".equals(((TextNode)text).getText().trim())) {
                        if ((text = text.getPreviousSibling()) != null) continue;
                        return "";
                    }
                    result = ((TextNode)text).getText();
                } else {
                    Node text = breakLines.elementAt(row - 1).getNextSibling();
                    while (!(text instanceof TextNode) || "".equals(((TextNode)text).getText().trim())) {
                        if ((text = text.getNextSibling()) != null) continue;
                        return "";
                    }
                    result = ((TextNode)text).getText();
                }
            }
        }
        result = result.replaceAll("&nbsp;", " ");
        return result.trim();
    }

    public synchronized void updateSatChannels(URL source) throws IOException {
        ArrayList<String> tvFilter = new ArrayList<String>();
        HashSet<String> coverages = new HashSet<String>();
        tvFilter.add("TV-DIG-CRYPT");
        tvFilter.add("TV-DIG");
        tvFilter.add("R-DIG");
        tvFilter.add("R-DIG-CRYPT");
        tvFilter.add("TV-HD");
        HashSet<Media> newMedias = new HashSet<Media>();
        newMedias.clear();
        logger.info((Object)("Downloading " + source.toString()));
        try {
            Parser parser = new Parser(source.openConnection());
            NodeList rows = parser.parse((NodeFilter)new TagNameFilter("tr"));
            logger.info((Object)(source.toString() + " downloaded and parsed."));
            int frequency = 0;
            char polarisation = 'A';
            String coverage = "";
            OrFilter thTagFilter = new OrFilter((NodeFilter)new TagNameFilter("th"), (NodeFilter)new HasAttributeFilter("rowspan"));
            TagNameFilter tdTagFilter = new TagNameFilter("td");
            for (int i = 0; i < rows.size(); ++i) {
                Node node = rows.elementAt(i);
                NodeList thCells = node.getChildren().extractAllNodesThatMatch((NodeFilter)thTagFilter);
                NodeList tdCells = node.getChildren().extractAllNodesThatMatch((NodeFilter)tdTagFilter);
                if (tdCells.size() != 8) continue;
                if (thCells.size() == 2) {
                    frequency = (int)(Double.parseDouble(DataImpl.htmlCellExtract(thCells, 0, 1, 2).split(" ")[0]) * 1000.0);
                    polarisation = DataImpl.htmlCellExtract(thCells, 0, 2, 2).charAt(0);
                    coverage = DataImpl.htmlCellExtract(thCells, 1, 0, 0);
                }
                String name = DataImpl.htmlCellExtract(tdCells, 1, 0, 3);
                String category = DataImpl.htmlCellExtract(tdCells, 0, 0, 2);
                String encryption = DataImpl.htmlCellExtract(tdCells, 2, 1, 3);
                int symbolRate = 27500;
                try {
                    symbolRate = (int)Double.parseDouble(DataImpl.htmlCellExtract(tdCells, 3, 0, 3)) * 1000;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                int errorCorrection = 9;
                try {
                    errorCorrection = Integer.parseInt(DataImpl.htmlCellExtract(tdCells, 3, 0, 3).substring(0, 1));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                }
                catch (StringIndexOutOfBoundsException e) {
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                int sid = 0;
                try {
                    sid = Integer.parseInt(DataImpl.htmlCellExtract(tdCells, 4, 1, 3));
                }
                catch (NumberFormatException e) {
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                String country = DataImpl.htmlCellExtract(tdCells, 5, 0, 3);
                SatChannel ch = new SatChannel();
                ch.setFrequency(frequency);
                ch.setPolarisation(polarisation);
                ch.setCoverage(coverage);
                ch.setName(name);
                ch.setCategory(category);
                ch.setEncryption(encryption);
                ch.setSymbolRate(symbolRate);
                ch.setErrorCorrection(errorCorrection);
                ch.setSid(sid);
                ch.setCountry(country);
                if (!tvFilter.contains(ch.getCategory())) continue;
                newMedias.add((Media)ch);
            }
        }
        catch (ParserException e) {
            throw new IOException();
        }
        List<Media> medias = this.vlmaDao.getMedias();
        for (Media ch : newMedias) {
            logger.debug((Object)("Adding " + ch.getName()));
            coverages.add(((SatChannel)ch).getCoverage());
            for (Media media : medias) {
                if (!ch.equals(media)) continue;
                ch.setProgram(media.getProgram());
            }
        }
        logger.debug((Object)("Got " + newMedias.size() + " channels"));
        ArrayList<Media> mediasToRemove = new ArrayList<Media>();
        for (Media ch : medias) {
            if (!(ch instanceof SatChannel) || !coverages.contains(((SatChannel)ch).getCoverage())) continue;
            mediasToRemove.add(ch);
        }
        this.vlmaDao.removeAll(mediasToRemove);
        this.vlmaDao.addAll(newMedias);
        logger.info((Object)("Ending analysis of " + source.toString()));
    }

    public void giveOrders() {
        this.vlmaService.giveOrders();
    }

    public List<Command> getCommands() {
        return this.commandLogger.getCommands();
    }

    public void startOrderMonitoring() {
        this.vlmaService.startOrderMonitoring();
    }

    public void startCheckAllVLCs() {
        this.vlmaService.startCheckAllVLCs();
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setDaemon(Daemon daemon) {
        this.daemon = daemon;
    }

    public void setCommandLogger(CommandLogger commandLogger) {
        this.commandLogger = commandLogger;
    }

    public void setIpBank(IpBank ipBank) {
        this.ipBank = ipBank;
    }

    public void setProgramFactory(ProgramFactory programFactory) {
        this.programFactory = programFactory;
    }

    public void setVlmaDao(VLMaDao vlmaDao) {
        this.vlmaDao = vlmaDao;
    }

    public void setVlmaService(VLMaService vlmaService) {
        this.vlmaService = vlmaService;
    }
}

