/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.posizione;

import finanze.IDTE.studi2002.calcolo.CalcoloAS;
import finanze.IDTE.studi2002.campi.AlfaNumericModel;
import finanze.IDTE.studi2002.campi.ComboBoxModel;
import finanze.IDTE.studi2002.campi.ControlloFormaleException;
import finanze.IDTE.studi2002.campi.GericoModel;
import finanze.IDTE.studi2002.campi.NonCoerenzaException;
import finanze.IDTE.studi2002.campi.RangeNumericModel;
import finanze.IDTE.studi2002.campi.ToggleButtonModel;
import finanze.IDTE.studi2002.campi.ValutaNumericModel;
import finanze.IDTE.studi2002.controlli.ControlloRicaviProventi;
import finanze.IDTE.studi2002.controlli.GericoControllo;
import finanze.IDTE.studi2002.generale.Arrays;
import finanze.IDTE.studi2002.generale.Comparator;
import finanze.IDTE.studi2002.main.Anomalia;
import finanze.IDTE.studi2002.posizione.Chiave;
import finanze.IDTE.studi2002.posizione.ChiaveAnnotazione;
import finanze.IDTE.studi2002.posizione.ChiaveStudio;
import finanze.IDTE.studi2002.posizione.ModelloM;
import finanze.IDTE.studi2002.posizione.ModelloN;
import finanze.IDTE.studi2002.posizione.Posizione;
import finanze.IDTE.studi2002.posizione.StrutturaMultiposizione;
import finanze.IDTE.studi2002.risorse.ServizioAnnotazioneSet;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Multiposizione {
    private ModelloM modelloM = null;
    private Vector posizioni = null;
    private ChiaveAnnotazione chiaveAS = null;
    private Vector messaggioErrore = null;
    private double[][] marginali = null;
    private ModelloN modelloN = null;
    private boolean salvata;
    private boolean memorizzata;
    private boolean calcolata;
    private Vector vecMessaggiErrori = new Vector();
    public static final String CODE_ALIQUOTA_MEDIA = "AliquotaMedia";
    public static final String CODE_IVA_DOVUTA_STIMATO = "IvaDovutaStimato";
    public static final String CODE_IVA_DOVUTA_MINIMO = "IvaDovutaMinimo";
    private ServizioAnnotazioneSet sas = null;

    public Multiposizione() {
        this.messaggioErrore = new Vector();
        this.posizioni = new Vector();
        this.sas = new ServizioAnnotazioneSet();
    }

    public Multiposizione(ChiaveAnnotazione chiave, ModelloM modelloM) {
        this.chiaveAS = chiave;
        this.modelloM = modelloM;
        this.messaggioErrore = new Vector();
        this.posizioni = new Vector();
        File f = new File("TraceAll.txt");
        f.delete();
    }

    public boolean apri(StrutturaMultiposizione[] dati) {
        boolean flag = this.creaModelloM(dati[0]);
        if (!this.creaModelloN(dati[1]) || !flag) {
            return false;
        }
        Vector righeModelloM = this.getRigheModelloM(0);
        if (this.controlloEsclusioni() && righeModelloM.size() != dati.length - 2) {
            Anomalia anomalia = new Anomalia(dati[0].getChiave(), "Q", "scarto", "320");
            this.messaggioErrore.addElement(anomalia);
            return false;
        }
        this.posizioni = new Vector();
        int i = 2;
        while (i < dati.length) {
            String codiceStudio;
            String progressivo;
            StrutturaMultiposizione sm = dati[i];
            if (this.controlloEsclusioni() && !this.getPosizioneTrovata(righeModelloM, progressivo = ((ChiaveStudio)sm.getChiave()).getProgressivo(), codiceStudio = ((ChiaveStudio)sm.getChiave()).getCodiceStudio())) {
                Anomalia anomalia = new Anomalia(new ChiaveStudio(""), "S", "scarto", "320");
                this.messaggioErrore.addElement(anomalia);
                break;
            }
            Hashtable codiciMultiplo = this.sas.getStudiConMultipli();
            Posizione posizione = new Posizione((ChiaveStudio)sm.getChiave(), "S");
            posizione.leggi(sm.getCampi());
            if (codiciMultiplo.get(((ChiaveStudio)sm.getChiave()).getCodiceStudio().toUpperCase()) != null) {
                posizione.getChiave().setProgressivoValido(posizione.getChiave().getProgressivo());
                posizione.getChiave().setProgressivo("99");
                try {
                    posizione.getCampo("Progressivo").setValore("99");
                }
                catch (ControlloFormaleException cfe) {
                    cfe.printStackTrace();
                }
            }
            if (posizione.getMessaggioErrore().size() == 0) {
                this.posizioni.addElement(posizione);
            } else {
                int j = 0;
                while (j < posizione.getMessaggioErrore().size()) {
                    this.messaggioErrore.addElement(posizione.getMessaggioErrore().elementAt(j));
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean controllaEsistenzaModelloN() {
        return true;
    }

    private void controllaPresenzaF15(double punto) {
        int i = 0;
        while (i < this.posizioni.size()) {
            if (punto == Double.valueOf(((Posizione)this.posizioni.elementAt(i)).getChiave().getProgressivo()) && !((Posizione)this.posizioni.elementAt(i)).getCampo("F01501").isValorePredefinito()) {
                Anomalia anomalia = new Anomalia(((Posizione)this.posizioni.elementAt(i)).getChiave(), "S", "scarto_confermabile", "305", String.valueOf(punto));
                this.vecMessaggiErrori.addElement(anomalia);
                return;
            }
            ++i;
        }
    }

    private boolean controllaRicagF15(double punto, double sommaRicag) {
        double sommaF15 = 0.0;
        boolean errori = false;
        boolean default_F15 = true;
        int i = 0;
        while (i < this.posizioni.size()) {
            if (punto == Double.valueOf(((Posizione)this.posizioni.elementAt(i)).getChiave().getProgressivo())) {
                if (!((Posizione)this.posizioni.elementAt(i)).getCampo("F01501").isValorePredefinito()) {
                    if (((Posizione)this.posizioni.elementAt(i)).getCampo("F01502").isValorePredefinito()) {
                        Anomalia anomalia = new Anomalia(((Posizione)this.posizioni.elementAt(i)).getChiave(), "S", "scarto_confermabile", "306");
                        this.vecMessaggiErrori.addElement(anomalia);
                        errori = true;
                    }
                    default_F15 = false;
                }
                sommaF15 += Double.valueOf(((Posizione)this.posizioni.elementAt(i)).getCampo("F01501").getValue()).doubleValue();
            }
            ++i;
        }
        if (errori || default_F15) {
            return false;
        }
        if (sommaF15 != sommaRicag) {
            Anomalia anomalia = new Anomalia(this.modelloM.getChiave(), "Q", "scarto_confermabile", "321", String.valueOf(punto));
            this.vecMessaggiErrori.addElement(anomalia);
        }
        return true;
    }

    private void controllaRicagF15AnnotazioneDistintaNo(double punto) {
        int i = 0;
        while (i < this.posizioni.size()) {
            if (punto == Double.valueOf(((Posizione)this.posizioni.elementAt(i)).getChiave().getProgressivo()) && !((Posizione)this.posizioni.elementAt(i)).getCampo("F01501").isValorePredefinito()) {
                Anomalia anomalia = new Anomalia(((Posizione)this.posizioni.elementAt(i)).getChiave(), "S", "scarto_confermabile", "307", String.valueOf(punto));
                this.vecMessaggiErrori.addElement(anomalia);
                return;
            }
            ++i;
        }
    }

    private void controlloAnnotazioneDistinta() {
        int numeroQuadriMultipli = this.modelloM.getNumeroQuadriMultipli();
        Vector modelMultiplo = null;
        boolean annotazioneDistinta = false;
        int i = 0;
        while (i < numeroQuadriMultipli) {
            modelMultiplo = this.modelloM.getQuadroMultiplo(i, 5);
            if (((GericoModel)modelMultiplo.elementAt(3)).getValue().equalsIgnoreCase("0")) {
                annotazioneDistinta = true;
                break;
            }
            ++i;
        }
        if (annotazioneDistinta) {
            boolean defaultValue = true;
            Hashtable campi = this.modelloN.getCampi();
            Vector<GericoModel> campiN = new Vector<GericoModel>();
            Enumeration enumeration = campi.elements();
            while (enumeration.hasMoreElements()) {
                GericoModel gm = (GericoModel)enumeration.nextElement();
                if (!gm.getCode().startsWith("N0")) continue;
                campiN.addElement(gm);
            }
            Object[] obj = new Object[campiN.size()];
            campiN.copyInto(obj);
            Arrays.sort(obj, new Comparator(){

                public int compare(Object obj1, Object obj2) {
                    int s1 = Integer.parseInt(((GericoModel)obj1).getCode().substring(2, 4));
                    int s2 = Integer.parseInt(((GericoModel)obj2).getCode().substring(2, 4));
                    return s1 - s2;
                }
            });
            int i2 = 0;
            while (i2 < 30) {
                if (!((GericoModel)obj[i2]).isValorePredefinito()) {
                    defaultValue = false;
                    break;
                }
                ++i2;
            }
            if (defaultValue) {
                Anomalia anomalia = new Anomalia(this.modelloM.getChiave(), "Q", "scarto_confermabile", "302");
                this.vecMessaggiErrori.addElement(anomalia);
            }
        }
    }

    private void controlloCoerenzaRicaviDichiarati() {
        Vector modelMultiplo = null;
        double ricavoPosizione = 0.0;
        int numeroQuadriMultipli = this.modelloM.getNumeroQuadriMultipli();
        int i = 0;
        while (i < this.posizioni.size()) {
            Posizione posizione = (Posizione)this.posizioni.elementAt(i);
            String codice = posizione.getChiave().getCodiceStudio();
            Hashtable codiciMultipli = this.sas.getStudiConMultipli();
            codice = codiciMultipli.get(codice.toUpperCase()) != null ? String.valueOf(codice) + "99" : String.valueOf(codice) + posizione.getChiave().getProgressivo();
            double f14 = Double.valueOf(posizione.getCampo("F01401").getValue());
            double f16_1 = Double.valueOf(posizione.getCampo("F01601").getValue());
            double f16_2 = Double.valueOf(posizione.getCampo("F01602").getValue());
            double f07 = Double.valueOf(posizione.getCampo("F00701").getValue());
            double f08 = Double.valueOf(posizione.getCampo("F00801").getValue());
            double f03 = Double.valueOf(posizione.getCampo("F00301").getValue());
            double f04 = Double.valueOf(posizione.getCampo("F00401").getValue());
            double f7_f8 = f07 - f08;
            double f3_f4 = f03 - f04;
            ricavoPosizione = f14 + f16_1 - f16_2 + f7_f8 - f3_f4;
            int j = 0;
            while (j < numeroQuadriMultipli) {
                modelMultiplo = this.modelloM.getQuadroMultiplo(j, 5);
                String codiceMultiplo = ((GericoModel)modelMultiplo.elementAt(1)).getValue();
                if ((codiceMultiplo = String.valueOf(codiceMultiplo) + ((GericoModel)modelMultiplo.elementAt(0)).getValue()).equalsIgnoreCase(codice) && ricavoPosizione != Double.valueOf(((GericoModel)modelMultiplo.elementAt(2)).getValue())) {
                    Anomalia anomalia = new Anomalia(posizione.getChiave(), "S", "scarto_confermabile", "304");
                    this.vecMessaggiErrori.addElement(anomalia);
                }
                ++j;
            }
            ++i;
        }
    }

    private void controlloEsclusione() {
        try {
            GericoControllo ce = GericoControllo.getIstanza(new String[]{"CESC*M00001*M00105%205&", "Modello M"}, this.modelloM.getCampi());
            if (!ce.verifica()) {
                Anomalia anomalia = new Anomalia((Chiave)this.modelloM.getChiave(), "Q", ce);
                this.vecMessaggiErrori.addElement(anomalia);
            }
        }
        catch (NonCoerenzaException nonCoerenzaException) {}
    }

    public boolean controlloEsclusioni() {
        if (!((ComboBoxModel)this.modelloM.getCampi().get("EsclusioneGenerale")).isValorePredefinito()) {
            return false;
        }
        try {
            GericoControllo ce = GericoControllo.getIstanza(new String[]{"CESC*M00001*M00105%205&", "Modello M"}, this.modelloM.getCampi());
            if (!ce.verifica()) {
                return false;
            }
        }
        catch (NonCoerenzaException nonCoerenzaException) {}
        return true;
    }

    private double controlloSommaRicagAnnotazioneDistinta() {
        Vector quadroMultiplo = new Vector();
        int numeroQuadriMultipli = this.modelloM.getNumeroQuadriMultipli();
        Vector modelMultiplo = new Vector();
        int i = 0;
        while (i < numeroQuadriMultipli) {
            modelMultiplo = this.modelloM.getQuadroMultiplo(i, 5);
            quadroMultiplo.addElement(modelMultiplo);
            modelMultiplo = new Vector();
            ++i;
        }
        Object[] objMultiplo = new Object[quadroMultiplo.size()];
        quadroMultiplo.copyInto(objMultiplo);
        Arrays.sort(objMultiplo, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                double s1 = new Double(((GericoModel)((Vector)obj1).elementAt(0)).getValue());
                double s2 = new Double(((GericoModel)((Vector)obj2).elementAt(0)).getValue());
                return (int)(s1 - s2);
            }
        });
        double sommaRicagSi = 0.0;
        double sommaRicagNo = 0.0;
        double ricaviRicagNo = 0.0;
        double punto = 0.0;
        int j = 0;
        while (j < objMultiplo.length) {
            punto = Double.valueOf(((GericoModel)((Vector)objMultiplo[j]).elementAt(0)).getValue());
            int i2 = j;
            while (i2 < objMultiplo.length && punto == Double.valueOf(((GericoModel)((Vector)objMultiplo[i2]).elementAt(0)).getValue())) {
                if (((GericoModel)((Vector)objMultiplo[i2]).elementAt(1)).getValue().equalsIgnoreCase("RICAG") && ((GericoModel)((Vector)objMultiplo[i2]).elementAt(3)).getValue().equalsIgnoreCase("1")) {
                    sommaRicagSi += Double.valueOf(((GericoModel)((Vector)objMultiplo[i2]).elementAt(2)).getValue()).doubleValue();
                } else if (((GericoModel)((Vector)objMultiplo[i2]).elementAt(1)).getValue().equalsIgnoreCase("RICAG") && ((GericoModel)((Vector)objMultiplo[i2]).elementAt(3)).getValue().equalsIgnoreCase("0")) {
                    sommaRicagNo += Double.valueOf(((GericoModel)((Vector)objMultiplo[i2]).elementAt(2)).getValue()).doubleValue();
                }
                ++i2;
                ++j;
            }
            if (sommaRicagSi == 0.0 && sommaRicagNo == 0.0) {
                this.controllaPresenzaF15(punto);
            }
            if (sommaRicagSi > 0.0) {
                this.controllaRicagF15(punto, sommaRicagSi);
            }
            sommaRicagSi = 0.0;
            if (sommaRicagNo > 0.0) {
                this.controllaRicagF15AnnotazioneDistintaNo(punto);
            }
            ricaviRicagNo += sommaRicagNo;
            sommaRicagNo = 0.0;
        }
        return ricaviRicagNo;
    }

    private void controlloSommaRicavi() {
        double somma = 0.0;
        String[][] cfr_ignored_0 = new String[this.posizioni.size()][];
        Vector[] cfr_ignored_1 = new Vector[this.posizioni.size()];
        int codiceErrore = 148;
        int i = 0;
        while (i < this.posizioni.size()) {
            Posizione posizione = (Posizione)this.posizioni.elementAt(i);
            Vector controlli = posizione.getControlliQuadro("Elementi Contabili");
            int j = 0;
            while (j < controlli.size()) {
                GericoControllo controllo = (GericoControllo)controlli.elementAt(j);
                if (controllo instanceof ControlloRicaviProventi) {
                    somma += this.eseguiSomma(posizione, controllo.getCampiControllati(), ((ControlloRicaviProventi)controllo).getOperatori());
                    if (controllo.getCodErrore() != codiceErrore) {
                        codiceErrore = 110;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.modelloM.getNumeroQuadriMultipli()) {
            Vector v = this.modelloM.getQuadroMultiplo(i, 0);
            String codiceStudio = (String)v.elementAt(1);
            if (codiceStudio.equalsIgnoreCase("ricag")) {
                somma += Double.valueOf((String)v.elementAt(2)).doubleValue();
            }
            ++i;
        }
        somma += Double.valueOf(this.modelloN.getCampo("N02901").getValue()).doubleValue();
        if (ValutaNumericModel.flagEuro && somma > 5164569.0 || !ValutaNumericModel.flagEuro && somma > 1.0E7) {
            if (codiceErrore == 110) {
                Anomalia anomalia = new Anomalia(this.modelloM.getChiave(), "Q", "scarto_confermabile", "308");
                this.vecMessaggiErrori.addElement(anomalia);
            } else if (codiceErrore == 148) {
                Anomalia anomalia = new Anomalia(this.modelloM.getChiave(), "Q", "scarto_confermabile", "309");
                this.vecMessaggiErrori.addElement(anomalia);
            }
        }
    }

    private boolean creaModelloM(StrutturaMultiposizione sm) {
        this.chiaveAS = (ChiaveAnnotazione)sm.getChiave();
        this.modelloM = new ModelloM(this.chiaveAS);
        if (!this.modelloM.leggi(sm.getCampi())) {
            int i = 0;
            while (i < this.modelloM.getMessaggioErrore().size()) {
                this.messaggioErrore.addElement(this.modelloM.getMessaggioErrore().elementAt(i));
                ++i;
            }
            return false;
        }
        this.modelloM.eseguiControlliDocumento();
        Vector tempMessaggioErrore = this.modelloM.getMessaggioErrore();
        if (tempMessaggioErrore.size() != 0) {
            int i = 0;
            while (i < this.modelloM.getMessaggioErrore().size()) {
                this.messaggioErrore.addElement(this.modelloM.getMessaggioErrore().elementAt(i));
                ++i;
            }
            return false;
        }
        return true;
    }

    private boolean creaModelloN(StrutturaMultiposizione sm) {
        this.modelloN = new ModelloN(this.chiaveAS);
        if (!this.modelloN.leggi(sm.getCampi())) {
            int i = 0;
            while (i < this.modelloN.getMessaggioErrore().size()) {
                this.messaggioErrore.addElement(this.modelloN.getMessaggioErrore().elementAt(i));
                ++i;
            }
            return false;
        }
        this.modelloN.eseguiControlliDocumento();
        Vector tempMessaggioErrore = this.modelloN.getMessaggioErrore();
        if (tempMessaggioErrore.size() != 0) {
            int i = 0;
            while (i < this.modelloN.getMessaggioErrore().size()) {
                this.messaggioErrore.addElement(this.modelloN.getMessaggioErrore().elementAt(i));
                ++i;
            }
            return false;
        }
        return true;
    }

    private boolean eseguiControlli() {
        int i;
        boolean presenzaN = true;
        if (this.modelloN != null && presenzaN && !this.modelloN.eseguiControlliDocumento()) {
            Vector vettoreN = this.modelloN.getVecMsgErrori();
            i = 0;
            while (i < vettoreN.size()) {
                this.vecMessaggiErrori.addElement(vettoreN.elementAt(i));
                ++i;
            }
        }
        boolean controlliN = true;
        i = 0;
        while (i < this.vecMessaggiErrori.size()) {
            this.messaggioErrore.addElement(this.vecMessaggiErrori.elementAt(i));
            controlliN = false;
            ++i;
        }
        boolean controlliPosizioni = true;
        int i2 = 0;
        while (i2 < this.posizioni.size()) {
            Posizione posizione = (Posizione)this.posizioni.elementAt(i2);
            if (!posizione.eseguiControlliDocumento()) {
                int j = 0;
                while (j < posizione.getMessaggioErrore().size()) {
                    this.messaggioErrore.addElement(posizione.getMessaggioErrore().elementAt(j));
                    ++j;
                }
                controlliPosizioni = false;
            }
            ++i2;
        }
        return controlliPosizioni && controlliN;
    }

    private double eseguiSomma(Posizione posizione, String[] campiControllati, Vector operatori) {
        double somma = 0.0;
        int i = 0;
        while (i < campiControllati.length) {
            if (!campiControllati[i].equals("F01501")) {
                somma = operatori.elementAt(i).equals("+") ? (somma += Double.valueOf(posizione.getCampo(campiControllati[i]).getValue()).doubleValue()) : (somma -= Double.valueOf(posizione.getCampo(campiControllati[i]).getValue()).doubleValue());
            }
            ++i;
        }
        return somma;
    }

    public ChiaveAnnotazione getChiave() {
        return this.chiaveAS;
    }

    private Vector getDati() {
        Vector<Object[]> dati = new Vector<Object[]>();
        int j = 0;
        while (j < this.posizioni.size()) {
            Posizione posizione = (Posizione)this.posizioni.elementAt(j);
            ChiaveStudio chiave = posizione.getChiave();
            Vector models = this.getRigaModelloM(chiave.getProgressivo(), chiave.getCodiceStudio());
            ValutaNumericModel modelRicavo = (ValutaNumericModel)models.elementAt(2);
            ToggleButtonModel modelAnnotazioneDistinta = (ToggleButtonModel)models.elementAt(3);
            boolean annotazione = false;
            if (modelAnnotazioneDistinta.getValue().equals("1")) {
                annotazione = true;
            }
            AlfaNumericModel modelCodiceStudio = (AlfaNumericModel)models.elementAt(1);
            Object[] parametri = new Object[]{new Double(modelRicavo.doubleValue()), new Boolean(annotazione), posizione, new String(modelCodiceStudio.getValue())};
            dati.addElement(parametri);
            ++j;
        }
        return dati;
    }

    private int[] getIndiceRigheMarginali() {
        int numeroQuadriMultipli = this.modelloM.getNumeroQuadriMultipli();
        this.marginali = CalcoloAS.getMarginali(this.getParametriMarginali());
        Vector<Integer> temp = new Vector<Integer>();
        int i = 0;
        while (i < numeroQuadriMultipli) {
            boolean trovato = false;
            Vector models = this.modelloM.getQuadroMultiplo(i, 5);
            String punto = ((GericoModel)models.elementAt(0)).getValue();
            double valorePunto = new Double(punto);
            String ricavi = ((GericoModel)models.elementAt(2)).getValue();
            double valoreRicavi = new Double(ricavi);
            if (this.marginali != null) {
                int j = 0;
                while (j < this.marginali.length) {
                    if (valorePunto == this.marginali[j][0] && valoreRicavi == this.marginali[j][1]) {
                        trovato = true;
                        break;
                    }
                    ++j;
                }
            }
            String codice = ((GericoModel)models.elementAt(1)).getValue();
            if (trovato || codice.equalsIgnoreCase("ricag")) {
                temp.addElement(new Integer(i));
            }
            ++i;
        }
        int[] indici = null;
        if (temp.size() > 0) {
            indici = new int[temp.size()];
            int i2 = 0;
            while (i2 < temp.size()) {
                indici[i2] = (Integer)temp.elementAt(i2);
                ++i2;
            }
        }
        return indici;
    }

    public Vector getMessaggioErrore() {
        return this.messaggioErrore;
    }

    private String getModelloDichiarazione(StrutturaMultiposizione[] dati) {
        int j = 1;
        while (j < dati.length) {
            String modelloDichiarazuione;
            StrutturaMultiposizione sm = dati[j];
            if (sm.getTipo().equals("S") && (modelloDichiarazuione = (String)sm.getCampi().get("ModelloDichiarazione")) != null) {
                return modelloDichiarazuione;
            }
            ++j;
        }
        return null;
    }

    private Object[][] getParametriMarginali() {
        int numeroQuadriMultipli = this.modelloM.getNumeroQuadriMultipli();
        Object[][] obj = new Object[numeroQuadriMultipli][3];
        int i = 0;
        while (i < numeroQuadriMultipli) {
            Vector models = this.modelloM.getQuadroMultiplo(i, 5);
            String progressivo = ((GericoModel)models.elementAt(0)).getValue();
            String codice = ((GericoModel)models.elementAt(1)).getValue();
            String ricavi = ((GericoModel)models.elementAt(2)).getValue();
            obj[i][0] = new Double(progressivo);
            obj[i][1] = new Double(ricavi);
            obj[i][2] = codice;
            ++i;
        }
        return obj;
    }

    private StrutturaMultiposizione getPosizioneTrovata(StrutturaMultiposizione[] dati, ChiaveStudio chiaveStudio) {
        int j = 1;
        while (j < dati.length) {
            StrutturaMultiposizione sm = dati[j];
            if (sm.getTipo().equals("S") && chiaveStudio.equals((ChiaveStudio)sm.getChiave())) {
                return sm;
            }
            ++j;
        }
        return null;
    }

    private StrutturaMultiposizione getPosizioneTrovata(StrutturaMultiposizione[] dati, String progressivo, String codiceStudio) {
        int j = 2;
        while (j < dati.length) {
            StrutturaMultiposizione sm = dati[j];
            ChiaveStudio chiaveStudio = (ChiaveStudio)sm.getChiave();
            if (Integer.parseInt(progressivo) == Integer.parseInt(chiaveStudio.getProgressivo()) && codiceStudio.equalsIgnoreCase(chiaveStudio.getCodiceStudio())) {
                return sm;
            }
            ++j;
        }
        return null;
    }

    private boolean getPosizioneTrovata(Vector righeModelloM, String progressivo, String codiceStudio) {
        Hashtable codiciMultipli = this.sas.getStudiConMultipli();
        int i = 0;
        while (i < righeModelloM.size()) {
            Vector campiModel = (Vector)righeModelloM.elementAt(i);
            String progressivoTemp = (String)campiModel.elementAt(0);
            String codiceStudioTemp = (String)campiModel.elementAt(1);
            if (codiciMultipli.get(codiceStudioTemp.toUpperCase()) != null ? (Integer.parseInt(progressivo) == Integer.parseInt(progressivoTemp) || Integer.parseInt(progressivo) == 1) && codiceStudio.equalsIgnoreCase(codiceStudioTemp) : Integer.parseInt(progressivo) == Integer.parseInt(progressivoTemp) && codiceStudio.equalsIgnoreCase(codiceStudioTemp)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vector getPosizioni() {
        return this.posizioni;
    }

    public StringBuffer getRecordPosizionaleModelloM() {
        return this.modelloM.getRecordPosizionale();
    }

    public StringBuffer getRecordPosizionaleModelloN() {
        return this.modelloN.getRecordPosizionale();
    }

    public Vector getRecordPosizionaliPosizioni() {
        if (!this.posizioni.isEmpty()) {
            Vector<StringBuffer> recordPosizioni = new Vector<StringBuffer>();
            int i = 0;
            while (i < this.posizioni.size()) {
                recordPosizioni.addElement(((Posizione)this.posizioni.elementAt(i)).getRecordPosizionale());
                ++i;
            }
            return recordPosizioni;
        }
        return this.posizioni;
    }

    private String getRicavoDichiarato() {
        int numeroQuadriMultipli = this.modelloM.getNumeroQuadriMultipli();
        Vector modelMultiplo = null;
        double ricaviM = 0.0;
        int i = 0;
        while (i < numeroQuadriMultipli) {
            modelMultiplo = this.modelloM.getQuadroMultiplo(i, 5);
            if (!((GericoModel)modelMultiplo.elementAt(1)).getValue().equalsIgnoreCase("ricag")) {
                ricaviM += Double.valueOf(((GericoModel)modelMultiplo.elementAt(2)).getValue()).doubleValue();
            }
            ++i;
        }
        double f16 = Double.valueOf(this.modelloN.getCampo("N02901").getValue()) - Double.valueOf(this.modelloN.getCampo("N02902").getValue());
        double ricaviTotali = ricaviM + f16;
        return Integer.toString((int)ricaviTotali);
    }

    private Vector getRigaModelloM(String progressivo, String codiceStudio) {
        Hashtable codici = this.sas.getStudiConMultipli();
        int i = 0;
        while (i < this.modelloM.getNumeroQuadriMultipli()) {
            Vector models = this.modelloM.getQuadroMultiplo(i, 5);
            RangeNumericModel modelProgressivo = (RangeNumericModel)models.elementAt(0);
            AlfaNumericModel modelCodiceStudio = (AlfaNumericModel)models.elementAt(1);
            if (codici.get(modelCodiceStudio.getValue().toUpperCase()) != null ? (Integer.parseInt(progressivo) == Integer.parseInt(modelProgressivo.getValue()) || Integer.parseInt(progressivo) == 1) && codiceStudio.equalsIgnoreCase(modelCodiceStudio.getValue()) : Integer.parseInt(progressivo) == Integer.parseInt(modelProgressivo.getValue()) && codiceStudio.equalsIgnoreCase(modelCodiceStudio.getValue())) {
                return models;
            }
            ++i;
        }
        return null;
    }

    public Vector getRigheModelloM(int tipo) {
        int[] indiciRigheMarginali = this.getIndiceRigheMarginali();
        int numeroQuadriMultipli = this.modelloM.getNumeroQuadriMultipli();
        Vector<Vector> v = new Vector<Vector>();
        int i = 0;
        while (i < numeroQuadriMultipli) {
            if (indiciRigheMarginali != null) {
                boolean trovato = false;
                int j = 0;
                while (j < indiciRigheMarginali.length) {
                    if (i == indiciRigheMarginali[j]) {
                        trovato = true;
                        break;
                    }
                    ++j;
                }
                if (!trovato) {
                    v.addElement(this.modelloM.getQuadroMultiplo(i, tipo));
                }
            } else {
                v.addElement(this.modelloM.getQuadroMultiplo(i, tipo));
            }
            ++i;
        }
        return v;
    }

    public Vector getVettMessaggioErrore() {
        return this.vecMessaggiErrori;
    }

    public void setModelloN(ModelloN modelloN) {
        this.modelloN = modelloN;
    }

    public void setPosizioni(Vector posizioni) {
        this.posizioni = posizioni;
    }

    public boolean verificaCalcolabilita() {
        boolean esito = false;
        this.vecMessaggiErrori.removeAllElements();
        Vector dati = this.getDati();
        if (dati.size() == 0) {
            esito = false;
        }
        this.controlloAnnotazioneDistinta();
        this.controlloEsclusione();
        this.controlloCoerenzaRicaviDichiarati();
        this.controlloSommaRicagAnnotazioneDistinta();
        this.controlloSommaRicavi();
        if (!this.vecMessaggiErrori.isEmpty()) {
            esito = false;
            int i = 0;
            while (i < this.vecMessaggiErrori.size()) {
                this.messaggioErrore.addElement(this.vecMessaggiErrori.elementAt(i));
                ++i;
            }
        } else if (this.eseguiControlli()) {
            esito = true;
        }
        return esito;
    }

    private void verificaSommaProbabilita(Vector dati) {
        int indiceMin = -1;
        int indiceMax = -1;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double somma = 0.0;
        int i = 0;
        int size = dati.size();
        while (i < size) {
            double d = new Double((String)dati.elementAt(i));
            somma += d;
            if (d < min && d != 0.0) {
                min = d;
                indiceMin = i;
            }
            if (d > max) {
                max = d;
                indiceMax = i;
            }
            ++i;
        }
        if (somma < 1.0) {
            String value = (String)dati.elementAt(indiceMin);
            double d1 = new Double(value);
            double d2 = new Double(1.0 - somma);
            d2 = Math.rint(d2 * 1000.0);
            String s = new Double(d1 + (d2 /= 1000.0)).toString();
            value = s.length() > 4 ? s.substring(0, 5) : s;
            dati.setElementAt(value, indiceMin);
        } else if (somma > 1.0) {
            String value = (String)dati.elementAt(indiceMax);
            double d1 = new Double(value);
            double d2 = new Double(somma - 1.0);
            d2 = Math.rint(d2 * 1000.0);
            String s = new Double(d1 - (d2 /= 1000.0)).toString();
            value = s.length() > 4 ? s.substring(0, 5) : s;
            dati.setElementAt(value, indiceMax);
        }
    }
}

