/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;
import sun.security.pkcs11.ConstructKeys;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_VERSION;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.util.KeyUtil;

final class P11RSACipher
extends CipherSpi {
    private static final int PKCS1_MIN_PADDING_LENGTH = 11;
    private static final byte[] B0 = new byte[0];
    private static final int MODE_ENCRYPT = 1;
    private static final int MODE_DECRYPT = 2;
    private static final int MODE_SIGN = 3;
    private static final int MODE_VERIFY = 4;
    private static final int PAD_NONE = 1;
    private static final int PAD_PKCS1 = 2;
    private final Token token;
    private final String algorithm;
    private final long mechanism;
    private Session session;
    private int mode;
    private int padType;
    private byte[] buffer;
    private int bufOfs;
    private P11Key p11Key;
    private boolean initialized;
    private int maxInputSize;
    private int outputSize;
    private AlgorithmParameterSpec spec = null;
    private SecureRandom random;

    P11RSACipher(Token token, String string, long l) throws PKCS11Exception {
        this.token = token;
        this.algorithm = "RSA";
        this.mechanism = l;
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!string.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("Unsupported mode " + string);
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (string2.equals("pkcs1padding")) {
            this.padType = 2;
        } else if (string2.equals("nopadding")) {
            this.padType = 1;
        } else {
            throw new NoSuchPaddingException("Unsupported padding " + string);
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        return this.outputSize;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.implInit(n, key);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof TlsRsaPremasterSecretParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Parameters not supported");
            }
            this.spec = algorithmParameterSpec;
            this.random = secureRandom;
        }
        this.implInit(n, key);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.implInit(n, key);
    }

    private void implInit(int n, Key key) throws InvalidKeyException {
        int n2;
        boolean bl;
        this.cancelOperation();
        this.p11Key = P11KeyFactory.convertKey(this.token, key, this.algorithm);
        if (n == 1) {
            bl = true;
        } else if (n == 2) {
            bl = false;
        } else {
            if (n == 3) {
                if (!this.p11Key.isPublic()) {
                    throw new InvalidKeyException("Wrap has to be used with public keys");
                }
                return;
            }
            if (n == 4) {
                if (!this.p11Key.isPrivate()) {
                    throw new InvalidKeyException("Unwrap has to be used with private keys");
                }
                return;
            }
            throw new InvalidKeyException("Unsupported mode: " + n);
        }
        if (this.p11Key.isPublic()) {
            this.mode = bl ? 1 : 4;
        } else if (this.p11Key.isPrivate()) {
            this.mode = bl ? 3 : 2;
        } else {
            throw new InvalidKeyException("Unknown key type: " + this.p11Key);
        }
        this.outputSize = n2 = this.p11Key.length() + 7 >> 3;
        this.buffer = new byte[n2];
        this.maxInputSize = this.padType == 2 && bl ? n2 - 11 : n2;
        try {
            this.initialize();
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("init() failed", pKCS11Exception);
        }
    }

    private void cancelOperation() {
        this.token.ensureValid();
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        if (this.session == null || !this.token.explicitCancel) {
            return;
        }
        if (!this.session.hasObjects()) {
            this.session = this.token.killSession(this.session);
            return;
        }
        try {
            PKCS11 pKCS11 = this.token.p11;
            int n = this.maxInputSize;
            int n2 = this.buffer.length;
            switch (this.mode) {
                case 1: {
                    pKCS11.C_Encrypt(this.session.id(), 0L, this.buffer, 0, n, 0L, this.buffer, 0, n2);
                    break;
                }
                case 2: {
                    pKCS11.C_Decrypt(this.session.id(), 0L, this.buffer, 0, n, 0L, this.buffer, 0, n2);
                    break;
                }
                case 3: {
                    byte[] byArray = new byte[this.maxInputSize];
                    pKCS11.C_Sign(this.session.id(), byArray);
                    break;
                }
                case 4: {
                    pKCS11.C_VerifyRecover(this.session.id(), this.buffer, 0, n, this.buffer, 0, n2);
                    break;
                }
                default: {
                    throw new ProviderException("internal error");
                }
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
    }

    private void ensureInitialized() throws PKCS11Exception {
        this.token.ensureValid();
        if (!this.initialized) {
            this.initialize();
        }
    }

    private void initialize() throws PKCS11Exception {
        if (this.session == null) {
            this.session = this.token.getOpSession();
        }
        PKCS11 pKCS11 = this.token.p11;
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(this.mechanism);
        switch (this.mode) {
            case 1: {
                pKCS11.C_EncryptInit(this.session.id(), cK_MECHANISM, this.p11Key.keyID);
                break;
            }
            case 2: {
                pKCS11.C_DecryptInit(this.session.id(), cK_MECHANISM, this.p11Key.keyID);
                break;
            }
            case 3: {
                pKCS11.C_SignInit(this.session.id(), cK_MECHANISM, this.p11Key.keyID);
                break;
            }
            case 4: {
                pKCS11.C_VerifyRecoverInit(this.session.id(), cK_MECHANISM, this.p11Key.keyID);
                break;
            }
            default: {
                throw new AssertionError((Object)"internal error");
            }
        }
        this.bufOfs = 0;
        this.initialized = true;
    }

    private void implUpdate(byte[] byArray, int n, int n2) {
        try {
            this.ensureInitialized();
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("update() failed", pKCS11Exception);
        }
        if (n2 == 0 || byArray == null) {
            return;
        }
        if (this.bufOfs + n2 > this.maxInputSize) {
            this.bufOfs = this.maxInputSize + 1;
            return;
        }
        System.arraycopy(byArray, n, this.buffer, this.bufOfs, n2);
        this.bufOfs += n2;
    }

    private int implDoFinal(byte[] byArray, int n, int n2) throws BadPaddingException, IllegalBlockSizeException {
        if (this.bufOfs > this.maxInputSize) {
            throw new IllegalBlockSizeException("Data must not be longer than " + this.maxInputSize + " bytes");
        }
        try {
            int n3;
            this.ensureInitialized();
            PKCS11 pKCS11 = this.token.p11;
            switch (this.mode) {
                case 1: {
                    n3 = pKCS11.C_Encrypt(this.session.id(), 0L, this.buffer, 0, this.bufOfs, 0L, byArray, n, n2);
                    break;
                }
                case 2: {
                    n3 = pKCS11.C_Decrypt(this.session.id(), 0L, this.buffer, 0, this.bufOfs, 0L, byArray, n, n2);
                    break;
                }
                case 3: {
                    byte[] byArray2 = new byte[this.bufOfs];
                    System.arraycopy(this.buffer, 0, byArray2, 0, this.bufOfs);
                    byArray2 = pKCS11.C_Sign(this.session.id(), byArray2);
                    if (byArray2.length > n2) {
                        throw new BadPaddingException("Output buffer (" + n2 + ") is too small to hold the produced data (" + byArray2.length + ")");
                    }
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n3 = byArray2.length;
                    break;
                }
                case 4: {
                    n3 = pKCS11.C_VerifyRecover(this.session.id(), this.buffer, 0, this.bufOfs, byArray, n, n2);
                    break;
                }
                default: {
                    throw new ProviderException("internal error");
                }
            }
            int n4 = n3;
            return n4;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw (BadPaddingException)new BadPaddingException("doFinal() failed").initCause(pKCS11Exception);
        }
        finally {
            this.initialized = false;
            this.session = this.token.releaseSession(this.session);
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.implUpdate(byArray, n, n2);
        return B0;
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        this.implUpdate(byArray, n, n2);
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        this.implUpdate(byArray, n, n2);
        int n3 = this.implDoFinal(this.buffer, 0, this.buffer.length);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(this.buffer, 0, byArray2, 0, n3);
        return byArray2;
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.implUpdate(byArray, n, n2);
        return this.implDoFinal(byArray2, n3, byArray2.length - n3);
    }

    private byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException {
        byte[] byArray = new byte[2048];
        int n = this.implDoFinal(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    @Override
    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        String string = key.getAlgorithm();
        P11Key p11Key = null;
        try {
            p11Key = P11SecretKeyFactory.convertKey(this.token, key, string);
        }
        catch (InvalidKeyException invalidKeyException) {
            byte[] byArray = key.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("wrap() failed, no encoding available", invalidKeyException);
            }
            this.implInit(1, this.p11Key);
            this.implUpdate(byArray, 0, byArray.length);
            try {
                byte[] byArray2 = this.doFinal();
                return byArray2;
            }
            catch (BadPaddingException badPaddingException) {
                throw new InvalidKeyException("wrap() failed", badPaddingException);
            }
            finally {
                this.implInit(3, this.p11Key);
            }
        }
        Session session = null;
        try {
            session = this.token.getOpSession();
            byte[] byArray = this.token.p11.C_WrapKey(session.id(), new CK_MECHANISM(this.mechanism), this.p11Key.keyID, p11Key.keyID);
            return byArray;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("wrap() failed", pKCS11Exception);
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        boolean bl = string.equals("TlsRsaPremasterSecret");
        Exception exception = null;
        if (this.token.supportsRawSecretKeyImport()) {
            this.implInit(2, this.p11Key);
            try {
                Object object;
                if (byArray.length > this.maxInputSize) {
                    throw new InvalidKeyException("Key is too long for unwrapping");
                }
                byte[] byArray2 = null;
                this.implUpdate(byArray, 0, byArray.length);
                try {
                    byArray2 = this.doFinal();
                }
                catch (BadPaddingException badPaddingException) {
                    if (bl) {
                        exception = badPaddingException;
                    }
                    throw new InvalidKeyException("Unwrapping failed", badPaddingException);
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    throw new InvalidKeyException("Unwrapping failed", illegalBlockSizeException);
                }
                if (bl) {
                    if (!(this.spec instanceof TlsRsaPremasterSecretParameterSpec)) {
                        throw new IllegalStateException("No TlsRsaPremasterSecretParameterSpec specified");
                    }
                    object = (TlsRsaPremasterSecretParameterSpec)this.spec;
                    byArray2 = KeyUtil.checkTlsPreMasterSecretKey(((TlsRsaPremasterSecretParameterSpec)object).getClientVersion(), ((TlsRsaPremasterSecretParameterSpec)object).getServerVersion(), this.random, byArray2, exception != null);
                }
                object = ConstructKeys.constructKey(byArray2, string, n);
                return object;
            }
            finally {
                this.implInit(4, this.p11Key);
            }
        }
        Session session = null;
        SecretKey secretKey = null;
        try {
            try {
                session = this.token.getObjSession();
                long l = 16L;
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(256L, l)};
                cK_ATTRIBUTEArray = this.token.getAttributes("import", 4L, l, cK_ATTRIBUTEArray);
                long l2 = this.token.p11.C_UnwrapKey(session.id(), new CK_MECHANISM(this.mechanism), this.p11Key.keyID, byArray, cK_ATTRIBUTEArray);
                secretKey = P11Key.secretKey(session, l2, string, 384, cK_ATTRIBUTEArray);
            }
            catch (PKCS11Exception pKCS11Exception) {
                if (bl) {
                    exception = pKCS11Exception;
                }
                throw new InvalidKeyException("unwrap() failed", pKCS11Exception);
            }
            if (bl) {
                TlsRsaPremasterSecretParameterSpec tlsRsaPremasterSecretParameterSpec = (TlsRsaPremasterSecretParameterSpec)this.spec;
                secretKey = P11RSACipher.polishPreMasterSecretKey(this.token, session, exception, secretKey, tlsRsaPremasterSecretParameterSpec.getClientVersion(), tlsRsaPremasterSecretParameterSpec.getServerVersion());
            }
            SecretKey secretKey2 = secretKey;
            return secretKey2;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        int n = P11KeyFactory.convertKey(this.token, key, this.algorithm).length();
        return n;
    }

    private static SecretKey polishPreMasterSecretKey(Token token, Session session, Exception exception, SecretKey secretKey, int n, int n2) {
        SecretKey secretKey2;
        CK_VERSION cK_VERSION = new CK_VERSION(n >>> 8 & 0xFF, n & 0xFF);
        try {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = token.getAttributes("generate", 4L, 16L, new CK_ATTRIBUTE[0]);
            long l = token.p11.C_GenerateKey(session.id(), new CK_MECHANISM(880L, cK_VERSION), cK_ATTRIBUTEArray);
            secretKey2 = P11Key.secretKey(session, l, "TlsRsaPremasterSecret", 384, cK_ATTRIBUTEArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("Could not generate premaster secret", pKCS11Exception);
        }
        return exception == null ? secretKey : secretKey2;
    }
}

