/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.asn1.structures.RDN;
import iaik.utils.InternalErrorException;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.CRLException;
import java.util.Enumeration;
import java.util.Vector;

public class DistributionPoint {
    private String c = "authorityRevocationList;binary,certificateRevocationList;binary";
    X509CRL d;
    private GeneralNames e;
    private int a = -1;
    private ASN1Type b;
    private static final String f = "authorityRevocationList;binary,certificateRevocationList;binary";
    public static final int aACompromise = 256;
    public static final int privilegeWithdrawn = 128;
    public static final int certificateHold = 64;
    public static final int cessationOfOperation = 32;
    public static final int superseded = 16;
    public static final int affiliationChanged = 8;
    public static final int cACompromise = 4;
    public static final int keyCompromise = 2;
    public static final int unused = 1;

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.b != null) {
            stringBuffer.append("DistributionPoint: ");
            stringBuffer.append(String.valueOf(this.b.toString()) + "\n");
        }
        if (this.a > 0) {
            stringBuffer.append("reasonFlags: ");
            if ((this.a & 1) > 0) {
                stringBuffer.append("unused | ");
            }
            if ((this.a & 2) > 0) {
                stringBuffer.append("keyCompromise | ");
            }
            if ((this.a & 4) > 0) {
                stringBuffer.append("cACompromise | ");
            }
            if ((this.a & 8) > 0) {
                stringBuffer.append("affiliationChanged | ");
            }
            if ((this.a & 0x10) > 0) {
                stringBuffer.append("superseded | ");
            }
            if ((this.a & 0x20) > 0) {
                stringBuffer.append("cessationOfOperation | ");
            }
            if ((this.a & 0x40) > 0) {
                stringBuffer.append("certificateHold | ");
            }
            if ((this.a & 0x80) > 0) {
                stringBuffer.append("privilegeWithdrawn | ");
            }
            if ((this.a & 0x100) > 0) {
                stringBuffer.append("aACompromise | ");
            }
            stringBuffer.setLength(stringBuffer.length() - 3);
            stringBuffer.append("\n");
        }
        if (this.e != null) {
            stringBuffer.append("CRLIssuer:\n");
            stringBuffer.append(String.valueOf(this.e.toString()) + "\n");
        }
        stringBuffer.setLength((n2 = stringBuffer.length() - 1) < 0 ? 0 : n2);
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        boolean bl = true;
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.b != null) {
            int n2 = -1;
            if (this.b instanceof GeneralNames) {
                n2 = 0;
            } else if (this.b instanceof RDN) {
                n2 = 1;
            } else {
                throw new InternalErrorException("DistributionPointName: Unknown type [create]!");
            }
            CON_SPEC cON_SPEC = new CON_SPEC(n2, this.b.toASN1Object(), bl);
            sEQUENCE.addComponent(new CON_SPEC(0, cON_SPEC));
        }
        if (this.a != -1) {
            StringBuffer stringBuffer = new StringBuffer(Integer.toBinaryString(this.a));
            stringBuffer.reverse();
            sEQUENCE.addComponent(new CON_SPEC(1, new BIT_STRING(stringBuffer.toString()), bl));
        }
        if (this.e != null) {
            sEQUENCE.addComponent(new CON_SPEC(2, this.e.toASN1Object(), bl));
        }
        return sEQUENCE;
    }

    public void setReasonFlags(int n2) {
        this.a = n2;
    }

    public void setLdapAttributeDescription(String string) {
        if (string == null) {
            throw new NullPointerException("Attribute description may not be null!");
        }
        this.c = string;
    }

    public void setDistributionPointNameURIs(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new NullPointerException("No uri names specified");
        }
        if (this.b == null) {
            this.b = new GeneralNames();
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            ((GeneralNames)this.b).addName(new GeneralName(6, stringArray[n2]));
            ++n2;
        }
    }

    public void setDistributionPointName(ASN1Type aSN1Type) throws IllegalArgumentException {
        if (!(aSN1Type instanceof GeneralNames) && !(aSN1Type instanceof RDN)) {
            throw new IllegalArgumentException("Only instances of GeneralNames or RDN are accepted!");
        }
        this.b = aSN1Type;
    }

    public void setCrlIssuerName(X509Certificate x509Certificate) {
        if (x509Certificate != null) {
            Name name = (Name)x509Certificate.getSubjectDN();
            if (name == null) {
                throw new NullPointerException("Subject field of the crl issuer cert must not be empty!");
            }
            this.e = new GeneralNames(new GeneralName(4, name));
            return;
        }
        this.e = null;
    }

    public void setCrlIssuerName(Name name) {
        if (name != null) {
            this.e = new GeneralNames(new GeneralName(4, name));
            return;
        }
        this.e = null;
    }

    public void setCrlIssuer(GeneralNames generalNames) {
        this.e = generalNames;
    }

    public InputStream loadCrlStream(String string, Name name) throws IOException, MalformedURLException {
        InputStream inputStream = null;
        try {
            inputStream = this.a(string, name, false);
        }
        catch (CRLException cRLException) {}
        return inputStream;
    }

    public InputStream loadCrlStream() throws IOException, MalformedURLException {
        return this.loadCrlStream(null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public X509CRL loadCrl(String string, Name name) throws CRLException, IOException, MalformedURLException {
        X509CRL x509CRL;
        InputStream inputStream = null;
        try {
            inputStream = this.a(string, name, true);
            x509CRL = this.d;
            Object var6_5 = null;
            if (inputStream == null) return x509CRL;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
            return x509CRL;
        }
        catch (IOException iOException) {}
        return x509CRL;
    }

    public X509CRL loadCrl() throws CRLException, IOException, MalformedURLException {
        return this.loadCrl(null, null);
    }

    public boolean isSet(int n2) {
        boolean bl = false;
        if (this.a != -1) {
            bl = (this.a & n2) != 0;
        }
        return bl;
    }

    public int getReasonFlags() {
        return this.a;
    }

    public String[] getDistributionPointNameURIs() {
        Object[] objectArray = null;
        if (this.b instanceof GeneralNames) {
            Vector<String> vector = new Vector<String>();
            GeneralNames generalNames = (GeneralNames)this.b;
            Enumeration enumeration = generalNames.getNames();
            while (enumeration.hasMoreElements()) {
                String string;
                GeneralName generalName = (GeneralName)enumeration.nextElement();
                if (generalName.getType() != 6 || (string = (String)generalName.getName()) == null) continue;
                vector.addElement(string);
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        if (objectArray == null) {
            return new String[0];
        }
        return objectArray;
    }

    public ASN1Type getDistributionPointName() {
        return this.b;
    }

    private InputStream a(String string, Name name, boolean bl) throws CRLException, IOException, MalformedURLException {
        this.d = null;
        InputStream inputStream = null;
        String string2 = null;
        if (this.b != null) {
            if (this.b instanceof GeneralNames) {
                Exception exception = null;
                String[] stringArray = this.getDistributionPointNameURIs();
                if (stringArray.length == 0) {
                    throw new MalformedURLException("Only can handle distribution point general names of type uniformResourceIdentifier!");
                }
                int n2 = 0;
                while (n2 < stringArray.length) {
                    try {
                        inputStream = this.a(stringArray[n2], bl);
                        exception = null;
                        break;
                    }
                    catch (Exception exception2) {
                        if (exception == null) {
                            exception = exception2;
                        }
                        ++n2;
                    }
                }
                if (exception != null) {
                    if (exception instanceof MalformedURLException) {
                        throw (MalformedURLException)exception;
                    }
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    if (exception instanceof CRLException) {
                        throw (CRLException)exception;
                    }
                    throw new CRLException("Error loading crl: " + exception.toString());
                }
            } else {
                if (string == null || !string.toLowerCase().startsWith("ldap")) {
                    throw new MalformedURLException("Need LDAP url for RDN distribution point name!");
                }
                Name name2 = this.getCrlIssuerName();
                if (name2 == null) {
                    name2 = name;
                }
                if (name2 == null) {
                    throw new CRLException("Crl issuer required for RDN distribution point name!");
                }
                string2 = DistributionPoint.a(string, name2, (RDN)this.b, this.c);
                inputStream = this.a(string2, bl);
            }
        } else {
            Name name3 = this.getCrlIssuerName();
            if (name3 != null) {
                if (string == null || !string.toLowerCase().startsWith("ldap")) {
                    throw new MalformedURLException("Need LDAP url if dp name is not set but crl issuer is set!");
                }
                string2 = DistributionPoint.a(string, name3, null, this.c);
            } else {
                string2 = string;
            }
            if (string2 != null) {
                inputStream = this.a(string2, bl);
            } else {
                throw new CRLException("Cannot build url from where to download crl");
            }
        }
        return inputStream;
    }

    public Name getCrlIssuerName() {
        Name name = null;
        if (this.e != null) {
            Enumeration enumeration = this.e.getNames();
            while (enumeration.hasMoreElements()) {
                GeneralName generalName = (GeneralName)enumeration.nextElement();
                if (generalName.getType() != 4) continue;
                name = (Name)generalName.getName();
            }
        }
        return name;
    }

    public GeneralNames getCrlIssuer() {
        return this.e;
    }

    private InputStream a(String string, boolean bl) throws CRLException, IOException, MalformedURLException {
        InputStream inputStream;
        URL uRL;
        this.d = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new MalformedURLException("Error loading crl from " + string + ": " + malformedURLException.toString());
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            throw new IOException("Error loading crl from " + string + ": " + iOException.toString());
        }
        if (bl) {
            try {
                this.d = new X509CRL(inputStream);
            }
            catch (Exception exception) {
                throw new CRLException("Error loading crl from " + string + ": " + exception.getMessage());
            }
        }
        return inputStream;
    }

    public boolean containsUriDpName() {
        boolean bl = false;
        if (this.b != null && this.b instanceof GeneralNames) {
            bl = ((GeneralNames)this.b).containsGeneralName(6);
        }
        return bl;
    }

    private static String a(String string, Name name, RDN rDN, String string2) throws CRLException {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!string.endsWith("/")) {
            stringBuffer.append("/");
        }
        try {
            Name name2 = name;
            if (rDN != null) {
                name2 = new Name(DerCoder.decode(name.getEncoded()));
                name2.addRDN(rDN);
            }
            stringBuffer.append(name2.getRFC2253String());
        }
        catch (Exception exception) {
            throw new CRLException("Error building LDAP url: " + exception.toString());
        }
        stringBuffer.append("?" + string2);
        return stringBuffer.toString();
    }

    public DistributionPoint(String[] stringArray) {
        this();
        this.setDistributionPointNameURIs(stringArray);
    }

    public DistributionPoint(ASN1Type aSN1Type) throws IllegalArgumentException {
        this();
        this.setDistributionPointName(aSN1Type);
    }

    public DistributionPoint(ASN1Object aSN1Object) throws CodingException {
        this();
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("No DistributionPoint!");
        }
        int n2 = 0;
        while (n2 < aSN1Object.countComponents()) {
            CON_SPEC cON_SPEC = null;
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(n2);
            if (!aSN1Object2.isA(ASN.CON_SPEC)) {
                throw new CodingException("No DistributionPoint!");
            }
            switch (aSN1Object2.getAsnType().getTag()) {
                case 0: {
                    ASN1Object aSN1Object3;
                    ASN1Object aSN1Object4 = (ASN1Object)aSN1Object2.getValue();
                    if (!aSN1Object4.isA(ASN.CON_SPEC)) {
                        throw new CodingException("No DistributionPoint!");
                    }
                    cON_SPEC = (CON_SPEC)aSN1Object4;
                    int n3 = cON_SPEC.getAsnType().getTag();
                    if (n3 == 0) {
                        if (cON_SPEC.countComponents() > 1) {
                            cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                        }
                        this.b = new GeneralNames((ASN1Object)cON_SPEC.getValue());
                        break;
                    }
                    if (n3 == 1) {
                        if (cON_SPEC.countComponents() > 1) {
                            cON_SPEC.forceImplicitlyTagged(ASN.SET);
                        } else if (cON_SPEC.countComponents() == 1 && !(aSN1Object3 = cON_SPEC.getComponentAt(0)).isA(ASN.SET)) {
                            cON_SPEC.forceImplicitlyTagged(ASN.SET);
                        }
                        this.b = new RDN((ASN1Object)cON_SPEC.getValue());
                        break;
                    }
                    throw new InternalErrorException("DistributionPointName: Unknown type [parse]!");
                }
                case 1: {
                    cON_SPEC = (CON_SPEC)aSN1Object2;
                    if (cON_SPEC.isImplicitlyTagged()) {
                        cON_SPEC.forceImplicitlyTagged(ASN.BIT_STRING);
                    }
                    ASN1Object aSN1Object3 = (BIT_STRING)cON_SPEC.getValue();
                    StringBuffer stringBuffer = new StringBuffer(((BIT_STRING)aSN1Object3).getBinaryString()).reverse();
                    this.a = Integer.parseInt(stringBuffer.toString(), 2);
                    break;
                }
                case 2: {
                    cON_SPEC = (CON_SPEC)aSN1Object2;
                    if (cON_SPEC.countComponents() > 1) {
                        cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                    }
                    this.e = new GeneralNames((ASN1Object)aSN1Object2.getValue());
                    break;
                }
            }
            ++n2;
        }
    }

    public DistributionPoint() {
    }
}

