/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.security.dh.DHParameterGenerator;
import iaik.security.dh.DHPrivateKey;
import iaik.security.dh.DHPublicKey;
import iaik.security.random.SecRandom;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class DHKeyPairGenerator
extends KeyPairGenerator {
    BigInteger h;
    BigInteger f;
    private int i = -1;
    private int b = -1;
    private SecureRandom a;
    private static final byte[] d;
    private static final byte[] e;
    private static final byte[] c;
    private static final byte[] g;

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.a = secureRandom;
        if (algorithmParameterSpec instanceof DHParameterSpec) {
            this.f = ((DHParameterSpec)algorithmParameterSpec).getP();
            this.h = ((DHParameterSpec)algorithmParameterSpec).getG();
            this.b = this.f.bitLength();
            this.i = ((DHParameterSpec)algorithmParameterSpec).getL();
            if (this.i > this.b) {
                throw new InvalidAlgorithmParameterException("The size of the exponent must be less than the size of the modulus");
            }
        } else {
            throw new InvalidAlgorithmParameterException("Parameter must be a DHParameterSpec.");
        }
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        this.a = secureRandom;
        this.b = n2;
        switch (this.b) {
            case 512: {
                this.f = new BigInteger(1, c);
                this.h = new BigInteger(g);
                break;
            }
            case 1024: {
                this.f = new BigInteger(1, e);
                this.h = new BigInteger(g);
                break;
            }
            case 2048: {
                this.f = new BigInteger(1, d);
                this.h = new BigInteger(g);
                break;
            }
            default: {
                this.f = null;
                this.h = null;
            }
        }
        this.i = -1;
    }

    public void initialize(int n2) {
        this.initialize(n2, null);
    }

    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        Object object;
        Object object2;
        if (this.a == null) {
            this.a = SecRandom.getDefault();
        }
        if (this.b < 0) {
            this.b = 1024;
        }
        if (this.i <= 0) {
            this.i = 300;
        }
        DHParameterSpec dHParameterSpec = new DHParameterSpec(this.f, this.h);
        if (this.f == null || this.h == null) {
            try {
                object2 = new DHGenParameterSpec(this.b, this.i);
                object = new DHParameterGenerator();
                ((DHParameterGenerator)object).engineInit((AlgorithmParameterSpec)object2, this.a);
                AlgorithmParameters algorithmParameters = ((DHParameterGenerator)object).engineGenerateParameters();
                dHParameterSpec = (DHParameterSpec)algorithmParameters.getParameterSpec(dHParameterSpec.getClass());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new RuntimeException(invalidAlgorithmParameterException.toString());
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new RuntimeException(invalidParameterSpecException.toString());
            }
        }
        while ((bigInteger = new BigInteger(this.i, this.a)).bitLength() != this.i) {
        }
        object2 = new DHPrivateKey(bigInteger, dHParameterSpec);
        BigInteger bigInteger2 = dHParameterSpec.getG().modPow(bigInteger, dHParameterSpec.getP());
        object = new DHPublicKey(bigInteger2, dHParameterSpec);
        return new KeyPair((PublicKey)object, (PrivateKey)object2);
    }

    public DHKeyPairGenerator() {
        super("DH");
    }

    static {
        g = new byte[]{2};
        c = new byte[]{-1, -57, -123, 98, 127, -101, 46, 102, -36, 85, -49, -49, -107, -127, 82, -108, -56, -54, 76, 37, 121, -93, 107, -111, 34, 64, -92, -102, -118, -49, -103, 80, -27, -71, 101, -23, 12, 58, 67, 92, -128, 78, 45, 62, 124, 104, -3, -31, 24, -100, 69, 80, -37, -46, -97, -122, -123, 86, -90, 87, 29, 124, -122, -3};
        e = new byte[]{-24, 8, -30, 27, -100, 77, 111, -54, 99, -28, -39, 119, 15, 85, -58, 20, 80, 110, 93, 103, -32, 27, 97, -78, 50, 43, 35, -127, -65, -79, 58, -5, 104, -66, -92, 20, -32, -91, 35, -85, 56, 18, -34, -71, 98, -14, -50, -72, 93, 91, -70, -110, 38, -43, -7, -113, 34, 72, 14, 32, 16, -20, 89, 77, 89, 125, -59, -48, -35, -25, -114, -32, -84, 94, 5, -48, -85, -28, 51, -6, 102, -99, 98, -21, -100, -114, 107, 29, 80, 122, -55, 28, 126, 7, -127, 119, -8, 17, -35, -16, 55, 112, 27, 11, -98, 30, -63, 74, 5, -48, -109, -27, 81, 97, -105, -16, 51, 71, 125, 16, 59, -98, 33, -125, -8, -29, 87, -93};
        byte[] byArray = new byte[256];
        byArray[0] = -7;
        byArray[1] = -37;
        byArray[2] = -32;
        byArray[3] = -24;
        byArray[4] = -78;
        byArray[5] = 40;
        byArray[6] = -124;
        byArray[7] = -24;
        byArray[8] = -1;
        byArray[9] = 62;
        byArray[10] = 25;
        byArray[11] = -60;
        byArray[12] = 114;
        byArray[13] = -5;
        byArray[14] = 12;
        byArray[15] = 116;
        byArray[16] = 80;
        byArray[17] = 36;
        byArray[18] = -37;
        byArray[19] = 108;
        byArray[20] = -34;
        byArray[21] = 20;
        byArray[22] = -56;
        byArray[23] = -21;
        byArray[24] = 91;
        byArray[25] = 121;
        byArray[26] = 49;
        byArray[27] = 55;
        byArray[28] = -96;
        byArray[29] = -18;
        byArray[30] = -2;
        byArray[31] = -102;
        byArray[32] = -73;
        byArray[33] = -51;
        byArray[34] = 11;
        byArray[35] = -5;
        byArray[36] = 54;
        byArray[37] = 27;
        byArray[38] = -127;
        byArray[39] = 83;
        byArray[40] = 111;
        byArray[41] = -81;
        byArray[42] = 116;
        byArray[43] = -105;
        byArray[44] = 119;
        byArray[45] = -29;
        byArray[46] = -104;
        byArray[47] = 121;
        byArray[48] = -92;
        byArray[49] = -33;
        byArray[50] = 14;
        byArray[51] = -47;
        byArray[52] = 71;
        byArray[53] = 65;
        byArray[54] = 110;
        byArray[55] = -126;
        byArray[56] = 111;
        byArray[57] = 122;
        byArray[58] = -94;
        byArray[59] = 118;
        byArray[60] = 111;
        byArray[61] = -104;
        byArray[62] = 1;
        byArray[63] = -7;
        byArray[64] = -15;
        byArray[65] = 118;
        byArray[66] = -48;
        byArray[67] = -16;
        byArray[68] = -69;
        byArray[69] = -15;
        byArray[70] = -38;
        byArray[71] = -84;
        byArray[72] = -77;
        byArray[73] = -29;
        byArray[74] = -111;
        byArray[75] = 69;
        byArray[76] = 2;
        byArray[77] = 55;
        byArray[78] = 32;
        byArray[79] = 11;
        byArray[80] = 44;
        byArray[81] = 54;
        byArray[82] = 63;
        byArray[83] = -7;
        byArray[84] = -16;
        byArray[85] = -53;
        byArray[86] = -28;
        byArray[87] = -122;
        byArray[88] = 59;
        byArray[89] = -100;
        byArray[90] = -10;
        byArray[91] = -38;
        byArray[92] = 11;
        byArray[93] = -107;
        byArray[94] = 61;
        byArray[95] = 39;
        byArray[96] = 23;
        byArray[97] = -91;
        byArray[98] = -101;
        byArray[99] = 61;
        byArray[100] = -115;
        byArray[101] = -30;
        byArray[102] = -122;
        byArray[103] = -37;
        byArray[104] = 47;
        byArray[105] = -67;
        byArray[106] = 47;
        byArray[107] = 2;
        byArray[108] = 109;
        byArray[109] = 74;
        byArray[110] = -124;
        byArray[111] = -32;
        byArray[112] = -14;
        byArray[113] = 42;
        byArray[114] = 112;
        byArray[115] = 5;
        byArray[116] = -42;
        byArray[117] = 20;
        byArray[118] = -65;
        byArray[119] = 12;
        byArray[120] = 127;
        byArray[121] = -12;
        byArray[122] = -27;
        byArray[123] = 40;
        byArray[124] = 21;
        byArray[125] = -69;
        byArray[126] = 101;
        byArray[127] = 10;
        byArray[128] = -122;
        byArray[129] = -93;
        byArray[130] = -53;
        byArray[131] = -90;
        byArray[132] = -83;
        byArray[133] = -84;
        byArray[134] = 78;
        byArray[135] = -23;
        byArray[136] = 24;
        byArray[137] = 69;
        byArray[138] = 44;
        byArray[139] = 61;
        byArray[140] = -101;
        byArray[141] = 42;
        byArray[142] = -86;
        byArray[143] = -94;
        byArray[144] = -44;
        byArray[145] = -97;
        byArray[146] = 98;
        byArray[147] = 87;
        byArray[148] = -48;
        byArray[149] = -58;
        byArray[150] = 48;
        byArray[151] = 37;
        byArray[152] = -118;
        byArray[153] = 86;
        byArray[154] = -45;
        byArray[155] = -97;
        byArray[156] = -7;
        byArray[157] = 4;
        byArray[158] = 116;
        byArray[159] = 22;
        byArray[160] = 31;
        byArray[161] = -125;
        byArray[162] = 47;
        byArray[163] = 79;
        byArray[164] = -127;
        byArray[165] = 19;
        byArray[166] = -86;
        byArray[167] = -28;
        byArray[168] = 5;
        byArray[169] = -36;
        byArray[170] = 43;
        byArray[171] = 19;
        byArray[172] = -49;
        byArray[173] = -53;
        byArray[174] = -100;
        byArray[175] = -44;
        byArray[176] = 81;
        byArray[177] = -120;
        byArray[178] = 93;
        byArray[179] = -116;
        byArray[180] = -8;
        byArray[181] = -113;
        byArray[182] = 79;
        byArray[183] = 114;
        byArray[184] = -36;
        byArray[185] = -54;
        byArray[186] = -52;
        byArray[187] = -99;
        byArray[188] = 126;
        byArray[189] = 127;
        byArray[190] = 71;
        byArray[191] = 114;
        byArray[192] = -122;
        byArray[193] = 87;
        byArray[194] = 66;
        byArray[195] = 16;
        byArray[196] = -111;
        byArray[197] = -34;
        byArray[198] = -12;
        byArray[199] = 37;
        byArray[200] = 9;
        byArray[201] = 116;
        byArray[202] = -90;
        byArray[203] = -127;
        byArray[204] = 123;
        byArray[205] = -116;
        byArray[206] = 75;
        byArray[207] = -76;
        byArray[208] = 78;
        byArray[209] = -52;
        byArray[210] = 76;
        byArray[211] = 67;
        byArray[212] = 77;
        byArray[213] = -70;
        byArray[214] = -101;
        byArray[215] = 113;
        byArray[216] = -109;
        byArray[217] = -98;
        byArray[218] = -9;
        byArray[219] = 94;
        byArray[220] = 68;
        byArray[221] = 111;
        byArray[222] = -113;
        byArray[223] = -49;
        byArray[224] = 120;
        byArray[225] = -76;
        byArray[226] = 89;
        byArray[227] = -97;
        byArray[228] = 4;
        byArray[229] = -112;
        byArray[230] = 101;
        byArray[231] = 7;
        byArray[232] = 12;
        byArray[233] = 58;
        byArray[234] = -42;
        byArray[235] = -107;
        byArray[236] = 23;
        byArray[237] = -53;
        byArray[238] = -92;
        byArray[239] = -128;
        byArray[240] = -13;
        byArray[241] = -42;
        byArray[242] = -99;
        byArray[243] = 13;
        byArray[244] = -14;
        byArray[245] = -1;
        byArray[246] = -21;
        byArray[247] = 19;
        byArray[248] = 57;
        byArray[249] = -67;
        byArray[250] = 77;
        byArray[251] = -11;
        byArray[253] = -65;
        byArray[254] = 122;
        byArray[255] = 83;
        d = byArray;
    }
}

