/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.Extension;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLProtocolException;
import sun.misc.HexDumpEncoder;
import sun.security.provider.certpath.OCSPResponse;
import sun.security.provider.certpath.ResponderId;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.Record;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLStringizer;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.Utilities;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

final class CertStatusExtension {
    static final HandshakeProducer chNetworkProducer = new CHCertStatusReqProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new CHCertStatusReqConsumer();
    static final HandshakeProducer shNetworkProducer = new SHCertStatusReqProducer();
    static final SSLExtension.ExtensionConsumer shOnLoadConsumer = new SHCertStatusReqConsumer();
    static final HandshakeProducer ctNetworkProducer = new CTCertStatusResponseProducer();
    static final SSLExtension.ExtensionConsumer ctOnLoadConsumer = new CTCertStatusResponseConsumer();
    static final SSLStringizer certStatusReqStringizer = new CertStatusRequestStringizer();
    static final HandshakeProducer chV2NetworkProducer = new CHCertStatusReqV2Producer();
    static final SSLExtension.ExtensionConsumer chV2OnLoadConsumer = new CHCertStatusReqV2Consumer();
    static final HandshakeProducer shV2NetworkProducer = new SHCertStatusReqV2Producer();
    static final SSLExtension.ExtensionConsumer shV2OnLoadConsumer = new SHCertStatusReqV2Consumer();
    static final SSLStringizer certStatusReqV2Stringizer = new CertStatusRequestsStringizer();
    static final SSLStringizer certStatusRespStringizer = new CertStatusRespStringizer();

    CertStatusExtension() {
    }

    private static final class CTCertStatusResponseConsumer
    implements SSLExtension.ExtensionConsumer {
        private CTCertStatusResponseConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            CertStatusResponseSpec certStatusResponseSpec;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            try {
                certStatusResponseSpec = new CertStatusResponseSpec(byteBuffer);
            }
            catch (IOException iOException) {
                clientHandshakeContext.conContext.fatal(Alert.DECODE_ERROR, iOException);
                return;
            }
            if (!clientHandshakeContext.sslContext.isStaplingEnabled(true)) {
                return;
            }
            clientHandshakeContext.staplingActive = true;
            if (clientHandshakeContext.handshakeSession != null && !clientHandshakeContext.isResumption) {
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>(clientHandshakeContext.handshakeSession.getStatusResponses());
                arrayList.add(certStatusResponseSpec.statusResponse.encodedResponse);
                clientHandshakeContext.handshakeSession.setStatusResponses(arrayList);
            } else if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                SSLLogger.finest("Ignoring stapled data on resumed session", new Object[0]);
            }
        }
    }

    private static final class CTCertStatusResponseProducer
    implements HandshakeProducer {
        private CTCertStatusResponseProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            byte[] byArray = null;
            if (serverHandshakeContext.stapleParams == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.finest("Stapling is disabled for this connection", new Object[0]);
                }
                return null;
            }
            if (serverHandshakeContext.currentCertEntry == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.finest("Found null CertificateEntry in context", new Object[0]);
                }
                return null;
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(serverHandshakeContext.currentCertEntry.encoded));
                byte[] byArray2 = serverHandshakeContext.stapleParams.responseMap.get(x509Certificate);
                if (byArray2 == null) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                        SSLLogger.finest("No status response found for " + x509Certificate.getSubjectX500Principal(), new Object[0]);
                    }
                    serverHandshakeContext.currentCertEntry = null;
                    return null;
                }
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                    SSLLogger.finest("Found status response for " + x509Certificate.getSubjectX500Principal() + ", response length: " + byArray2.length, new Object[0]);
                }
                CertStatusResponse certStatusResponse = serverHandshakeContext.stapleParams.statReqType == CertStatusRequestType.OCSP ? new OCSPStatusResponse(serverHandshakeContext.stapleParams.statReqType.id, byArray2) : new CertStatusResponse(serverHandshakeContext.stapleParams.statReqType.id, byArray2);
                byArray = certStatusResponse.toByteArray();
            }
            catch (CertificateException certificateException) {
                serverHandshakeContext.conContext.fatal(Alert.BAD_CERTIFICATE, "Failed to parse server certificates", certificateException);
            }
            catch (IOException iOException) {
                serverHandshakeContext.conContext.fatal(Alert.BAD_CERT_STATUS_RESPONSE, "Failed to parse certificate status response", iOException);
            }
            serverHandshakeContext.currentCertEntry = null;
            return byArray;
        }
    }

    private static final class SHCertStatusReqV2Consumer
    implements SSLExtension.ExtensionConsumer {
        private SHCertStatusReqV2Consumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            CertStatusRequestV2Spec certStatusRequestV2Spec = (CertStatusRequestV2Spec)clientHandshakeContext.handshakeExtensions.get(SSLExtension.CH_STATUS_REQUEST_V2);
            if (certStatusRequestV2Spec == null) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected status_request_v2 extension in ServerHello");
            }
            if (byteBuffer.hasRemaining()) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Invalid status_request_v2 extension in ServerHello: the extension data must be empty");
            }
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.SH_STATUS_REQUEST_V2, CertStatusRequestV2Spec.DEFAULT);
            clientHandshakeContext.staplingActive = clientHandshakeContext.sslContext.isStaplingEnabled(true);
            if (clientHandshakeContext.staplingActive) {
                clientHandshakeContext.handshakeConsumers.put(SSLHandshake.CERTIFICATE_STATUS.id, SSLHandshake.CERTIFICATE_STATUS);
            }
        }
    }

    private static final class SHCertStatusReqV2Producer
    implements HandshakeProducer {
        private SHCertStatusReqV2Producer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (serverHandshakeContext.stapleParams == null || serverHandshakeContext.stapleParams.statusRespExt != SSLExtension.CH_STATUS_REQUEST_V2) {
                return null;
            }
            CertStatusRequestV2Spec certStatusRequestV2Spec = (CertStatusRequestV2Spec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_STATUS_REQUEST_V2);
            if (certStatusRequestV2Spec == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.finest("Ignore unavailable status_request_v2 extension", new Object[0]);
                }
                return null;
            }
            if (serverHandshakeContext.isResumption) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.finest("No status_request_v2 response for session resumption", new Object[0]);
                }
                return null;
            }
            byte[] byArray = new byte[]{};
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.SH_STATUS_REQUEST_V2, CertStatusRequestV2Spec.DEFAULT);
            return byArray;
        }
    }

    private static final class CHCertStatusReqV2Consumer
    implements SSLExtension.ExtensionConsumer {
        private CHCertStatusReqV2Consumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            CertStatusRequestV2Spec certStatusRequestV2Spec;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_STATUS_REQUEST_V2)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.finest("Ignore unavailable status_request_v2 extension", new Object[0]);
                }
                return;
            }
            try {
                certStatusRequestV2Spec = new CertStatusRequestV2Spec(byteBuffer);
            }
            catch (IOException iOException) {
                serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
                return;
            }
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.CH_STATUS_REQUEST_V2, certStatusRequestV2Spec);
            if (!serverHandshakeContext.isResumption) {
                serverHandshakeContext.handshakeProducers.putIfAbsent(SSLHandshake.CERTIFICATE_STATUS.id, SSLHandshake.CERTIFICATE_STATUS);
            }
        }
    }

    private static final class CHCertStatusReqV2Producer
    implements HandshakeProducer {
        private CHCertStatusReqV2Producer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslContext.isStaplingEnabled(true)) {
                return null;
            }
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_STATUS_REQUEST_V2)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.finest("Ignore unavailable status_request_v2 extension", new Object[0]);
                }
                return null;
            }
            byte[] byArray = new byte[]{0, 7, 2, 0, 4, 0, 0, 0, 0};
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.CH_STATUS_REQUEST_V2, CertStatusRequestV2Spec.DEFAULT);
            return byArray;
        }
    }

    private static final class CertStatusRequestsStringizer
    implements SSLStringizer {
        private CertStatusRequestsStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new CertStatusRequestV2Spec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }

    static final class CertStatusRequestV2Spec
    implements SSLExtension.SSLExtensionSpec {
        static final CertStatusRequestV2Spec DEFAULT = new CertStatusRequestV2Spec(new CertStatusRequest[]{OCSPStatusRequest.EMPTY_OCSP_MULTI});
        final CertStatusRequest[] certStatusRequests;

        private CertStatusRequestV2Spec(CertStatusRequest[] certStatusRequestArray) {
            this.certStatusRequests = certStatusRequestArray;
        }

        private CertStatusRequestV2Spec(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() == 0) {
                this.certStatusRequests = new CertStatusRequest[0];
                return;
            }
            if (byteBuffer.remaining() < 5) {
                throw new SSLProtocolException("Invalid status_request_v2 extension: insufficient data");
            }
            int n = Record.getInt16(byteBuffer);
            if (n <= 0) {
                throw new SSLProtocolException("certificate_status_req_list length must be positive (received length: " + n + ")");
            }
            int n2 = n;
            ArrayList<CertStatusRequest> arrayList = new ArrayList<CertStatusRequest>();
            while (n2 > 0) {
                byte by = (byte)Record.getInt8(byteBuffer);
                int n3 = Record.getInt16(byteBuffer);
                if (byteBuffer.remaining() < n3) {
                    throw new SSLProtocolException("Invalid status_request_v2 extension: insufficient data (request_length=" + n3 + ", remining=" + byteBuffer.remaining() + ")");
                }
                byte[] byArray = new byte[n3];
                if (byArray.length != 0) {
                    byteBuffer.get(byArray);
                }
                n2 -= 3;
                n2 -= n3;
                if (by == CertStatusRequestType.OCSP.id || by == CertStatusRequestType.OCSP_MULTI.id) {
                    if (byArray.length < 4) {
                        throw new SSLProtocolException("Invalid status_request_v2 extension: insufficient data");
                    }
                    arrayList.add(new OCSPStatusRequest(by, byArray));
                    continue;
                }
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.info("Unknown certificate status request (status type: " + by + ")", new Object[0]);
                }
                arrayList.add(new CertStatusRequest(by, byArray));
            }
            this.certStatusRequests = arrayList.toArray(new CertStatusRequest[0]);
        }

        public String toString() {
            if (this.certStatusRequests == null || this.certStatusRequests.length == 0) {
                return "<empty>";
            }
            MessageFormat messageFormat = new MessageFormat("\"cert status request\": '{'\n{0}\n'}'", Locale.ENGLISH);
            StringBuilder stringBuilder = new StringBuilder(512);
            boolean bl = true;
            for (CertStatusRequest certStatusRequest : this.certStatusRequests) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                Object[] objectArray = new Object[]{Utilities.indent(certStatusRequest.toString())};
                stringBuilder.append(messageFormat.format(objectArray));
            }
            return stringBuilder.toString();
        }
    }

    private static final class SHCertStatusReqConsumer
    implements SSLExtension.ExtensionConsumer {
        private SHCertStatusReqConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            CertStatusRequestSpec certStatusRequestSpec = (CertStatusRequestSpec)clientHandshakeContext.handshakeExtensions.get(SSLExtension.CH_STATUS_REQUEST);
            if (certStatusRequestSpec == null) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected status_request extension in ServerHello");
            }
            if (byteBuffer.hasRemaining()) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Invalid status_request extension in ServerHello message: the extension data must be empty");
            }
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.SH_STATUS_REQUEST, CertStatusRequestSpec.DEFAULT);
            clientHandshakeContext.staplingActive = clientHandshakeContext.sslContext.isStaplingEnabled(true);
            if (clientHandshakeContext.staplingActive) {
                clientHandshakeContext.handshakeConsumers.put(SSLHandshake.CERTIFICATE_STATUS.id, SSLHandshake.CERTIFICATE_STATUS);
            }
        }
    }

    private static final class SHCertStatusReqProducer
    implements HandshakeProducer {
        private SHCertStatusReqProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (serverHandshakeContext.stapleParams == null || serverHandshakeContext.stapleParams.statusRespExt != SSLExtension.CH_STATUS_REQUEST) {
                return null;
            }
            CertStatusRequestSpec certStatusRequestSpec = (CertStatusRequestSpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_STATUS_REQUEST);
            if (certStatusRequestSpec == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.finest("Ignore unavailable extension: " + SSLExtension.CH_STATUS_REQUEST.name, new Object[0]);
                }
                return null;
            }
            if (serverHandshakeContext.isResumption) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.finest("No status_request response for session resuming", new Object[0]);
                }
                return null;
            }
            byte[] byArray = new byte[]{};
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.SH_STATUS_REQUEST, CertStatusRequestSpec.DEFAULT);
            return byArray;
        }
    }

    private static final class CHCertStatusReqConsumer
    implements SSLExtension.ExtensionConsumer {
        private CHCertStatusReqConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            CertStatusRequestSpec certStatusRequestSpec;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_STATUS_REQUEST)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable extension: " + SSLExtension.CH_STATUS_REQUEST.name, new Object[0]);
                }
                return;
            }
            try {
                certStatusRequestSpec = new CertStatusRequestSpec(byteBuffer);
            }
            catch (IOException iOException) {
                serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
                return;
            }
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.CH_STATUS_REQUEST, certStatusRequestSpec);
            if (!serverHandshakeContext.isResumption && !serverHandshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
                serverHandshakeContext.handshakeProducers.put(SSLHandshake.CERTIFICATE_STATUS.id, SSLHandshake.CERTIFICATE_STATUS);
            }
        }
    }

    private static final class CHCertStatusReqProducer
    implements HandshakeProducer {
        private CHCertStatusReqProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslContext.isStaplingEnabled(true)) {
                return null;
            }
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_STATUS_REQUEST)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable extension: " + SSLExtension.CH_STATUS_REQUEST.name, new Object[0]);
                }
                return null;
            }
            byte[] byArray = new byte[]{1, 0, 0, 0, 0};
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.CH_STATUS_REQUEST, CertStatusRequestSpec.DEFAULT);
            return byArray;
        }
    }

    static final class OCSPStatusResponse
    extends CertStatusResponse {
        final OCSPResponse ocspResponse;

        private OCSPStatusResponse(byte by, byte[] byArray) throws IOException {
            super(by, byArray);
            if (byArray == null || byArray.length < 1) {
                throw new SSLProtocolException("Invalid OCSP status response: insufficient data");
            }
            this.ocspResponse = new OCSPResponse(byArray);
        }

        @Override
        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"certificate status response type\": {0}\n\"OCSP status response\": '{'\n{1}\n'}'", Locale.ENGLISH);
            Object[] objectArray = new Object[]{CertStatusRequestType.nameOf(this.statusType), Utilities.indent(this.ocspResponse.toString())};
            return messageFormat.format(objectArray);
        }
    }

    static class CertStatusResponse {
        final byte statusType;
        final byte[] encodedResponse;

        protected CertStatusResponse(byte by, byte[] byArray) {
            this.statusType = by;
            this.encodedResponse = byArray;
        }

        byte[] toByteArray() throws IOException {
            byte[] byArray = new byte[this.encodedResponse.length + 4];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Record.putInt8(byteBuffer, this.statusType);
            Record.putBytes24(byteBuffer, this.encodedResponse);
            return byteBuffer.array();
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"certificate status response type\": {0}\n\"encoded certificate status\": '{'\n{1}\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            String string = hexDumpEncoder.encodeBuffer(this.encodedResponse);
            Object[] objectArray = new Object[]{CertStatusRequestType.nameOf(this.statusType), Utilities.indent(string)};
            return messageFormat.format(objectArray);
        }
    }

    static final class OCSPStatusRequest
    extends CertStatusRequest {
        static final OCSPStatusRequest EMPTY_OCSP;
        static final OCSPStatusRequest EMPTY_OCSP_MULTI;
        final List<ResponderId> responderIds;
        final List<Extension> extensions;
        private final int ridListLen;
        private final int extListLen;

        private OCSPStatusRequest(byte by, byte[] byArray) throws IOException {
            super(by, byArray);
            int n;
            byte[] byArray2;
            if (byArray == null || byArray.length < 4) {
                throw new SSLProtocolException("Invalid OCSP status request: insufficient data");
            }
            ArrayList<ResponderId> arrayList = new ArrayList<ResponderId>();
            ArrayList<Extension> arrayList2 = new ArrayList<Extension>();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            this.ridListLen = Record.getInt16(byteBuffer);
            if (byteBuffer.remaining() < this.ridListLen + 2) {
                throw new SSLProtocolException("Invalid OCSP status request: insufficient data");
            }
            for (n = this.ridListLen; n >= 2; n -= byArray2.length + 2) {
                byArray2 = Record.getBytes16(byteBuffer);
                try {
                    arrayList.add(new ResponderId(byArray2));
                    continue;
                }
                catch (IOException iOException) {
                    throw new SSLProtocolException("Invalid OCSP status request: invalid responder ID");
                }
            }
            if (n != 0) {
                throw new SSLProtocolException("Invalid OCSP status request: incomplete data");
            }
            byArray2 = Record.getBytes16(byteBuffer);
            this.extListLen = byArray2.length;
            if (this.extListLen > 0) {
                try {
                    DerValue[] derValueArray;
                    DerInputStream derInputStream = new DerInputStream(byArray2);
                    for (DerValue derValue : derValueArray = derInputStream.getSequence(byArray2.length)) {
                        arrayList2.add(new sun.security.x509.Extension(derValue));
                    }
                }
                catch (IOException iOException) {
                    throw new SSLProtocolException("Invalid OCSP status request: invalid extension");
                }
            }
            this.responderIds = arrayList;
            this.extensions = arrayList2;
        }

        @Override
        public String toString() {
            Object[] objectArray;
            MessageFormat messageFormat = new MessageFormat("\"certificate status type\": {0}\n\"OCSP status request\": '{'\n{1}\n'}'", Locale.ENGLISH);
            MessageFormat messageFormat2 = new MessageFormat("\"responder_id\": {0}\n\"request extensions\": '{'\n{1}\n'}'", Locale.ENGLISH);
            String string = "<empty>";
            if (!this.responderIds.isEmpty()) {
                string = this.responderIds.toString();
            }
            String string2 = "<empty>";
            if (!this.extensions.isEmpty()) {
                objectArray = new StringBuilder(512);
                boolean bl = true;
                for (Extension extension : this.extensions) {
                    if (bl) {
                        bl = false;
                    } else {
                        objectArray.append(",\n");
                    }
                    objectArray.append("{\n").append(Utilities.indent(extension.toString())).append("}");
                }
                string2 = objectArray.toString();
            }
            objectArray = new Object[]{string, Utilities.indent(string2)};
            String string3 = messageFormat2.format(objectArray);
            Object[] objectArray2 = new Object[]{CertStatusRequestType.nameOf(this.statusType), Utilities.indent(string3)};
            return messageFormat.format(objectArray2);
        }

        static {
            OCSPStatusRequest oCSPStatusRequest = null;
            OCSPStatusRequest oCSPStatusRequest2 = null;
            try {
                oCSPStatusRequest = new OCSPStatusRequest(CertStatusRequestType.OCSP.id, new byte[]{0, 0, 0, 0});
                oCSPStatusRequest2 = new OCSPStatusRequest(CertStatusRequestType.OCSP_MULTI.id, new byte[]{0, 0, 0, 0});
            }
            catch (IOException iOException) {
                // empty catch block
            }
            EMPTY_OCSP = oCSPStatusRequest;
            EMPTY_OCSP_MULTI = oCSPStatusRequest2;
        }
    }

    static class CertStatusRequest {
        final byte statusType;
        final byte[] encodedRequest;

        protected CertStatusRequest(byte by, byte[] byArray) {
            this.statusType = by;
            this.encodedRequest = byArray;
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"certificate status type\": {0}\n\"encoded certificate status\": '{'\n{1}\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            String string = hexDumpEncoder.encodeBuffer(this.encodedRequest);
            Object[] objectArray = new Object[]{CertStatusRequestType.nameOf(this.statusType), Utilities.indent(string)};
            return messageFormat.format(objectArray);
        }
    }

    static enum CertStatusRequestType {
        OCSP(1, "ocsp"),
        OCSP_MULTI(2, "ocsp_multi");

        final byte id;
        final String name;

        private CertStatusRequestType(byte by, String string2) {
            this.id = by;
            this.name = string2;
        }

        static CertStatusRequestType valueOf(byte by) {
            for (CertStatusRequestType certStatusRequestType : CertStatusRequestType.values()) {
                if (certStatusRequestType.id != by) continue;
                return certStatusRequestType;
            }
            return null;
        }

        static String nameOf(byte by) {
            for (CertStatusRequestType certStatusRequestType : CertStatusRequestType.values()) {
                if (certStatusRequestType.id != by) continue;
                return certStatusRequestType.name;
            }
            return "UNDEFINED-CERT-STATUS-TYPE(" + by + ")";
        }
    }

    private static final class CertStatusRespStringizer
    implements SSLStringizer {
        private CertStatusRespStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new CertStatusResponseSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }

    private static final class CertStatusRequestStringizer
    implements SSLStringizer {
        private CertStatusRequestStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new CertStatusRequestSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }

    static final class CertStatusResponseSpec
    implements SSLExtension.SSLExtensionSpec {
        final CertStatusResponse statusResponse;

        private CertStatusResponseSpec(CertStatusResponse certStatusResponse) {
            this.statusResponse = certStatusResponse;
        }

        private CertStatusResponseSpec(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() < 2) {
                throw new SSLProtocolException("Invalid status_request extension: insufficient data");
            }
            byte by = (byte)Record.getInt8(byteBuffer);
            byte[] byArray = Record.getBytes24(byteBuffer);
            if (by == CertStatusRequestType.OCSP.id) {
                this.statusResponse = new OCSPStatusResponse(by, byArray);
            } else {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.info("Unknown certificate status response (status type: " + by + ")", new Object[0]);
                }
                this.statusResponse = new CertStatusResponse(by, byArray);
            }
        }

        public String toString() {
            return this.statusResponse == null ? "<empty>" : this.statusResponse.toString();
        }
    }

    static final class CertStatusRequestSpec
    implements SSLExtension.SSLExtensionSpec {
        static final CertStatusRequestSpec DEFAULT = new CertStatusRequestSpec(OCSPStatusRequest.EMPTY_OCSP);
        final CertStatusRequest statusRequest;

        private CertStatusRequestSpec(CertStatusRequest certStatusRequest) {
            this.statusRequest = certStatusRequest;
        }

        private CertStatusRequestSpec(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() == 0) {
                this.statusRequest = null;
                return;
            }
            if (byteBuffer.remaining() < 1) {
                throw new SSLProtocolException("Invalid status_request extension: insufficient data");
            }
            byte by = (byte)Record.getInt8(byteBuffer);
            byte[] byArray = new byte[byteBuffer.remaining()];
            if (byArray.length != 0) {
                byteBuffer.get(byArray);
            }
            if (by == CertStatusRequestType.OCSP.id) {
                this.statusRequest = new OCSPStatusRequest(by, byArray);
            } else {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.info("Unknown certificate status request (status type: " + by + ")", new Object[0]);
                }
                this.statusRequest = new CertStatusRequest(by, byArray);
            }
        }

        public String toString() {
            return this.statusRequest == null ? "<empty>" : this.statusRequest.toString();
        }
    }
}

